/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * Copyright  Acxiom Corporation, 2006
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for creating files.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "pvfs2-dist-simple-stripe.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "pint-distribution.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "ncache.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

enum
{
    CREATE_RETRY = 170
};

/* state function prototypes */
static int create_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_dspace_create_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_dspace_create_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_datafiles_setup_msgpair_array(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_datafiles_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_setattr_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_setattr_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_crdirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_crdirent_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_delete_handles_setup_msgpair_array(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int create_parent_getattr_inspect(
    PINT_client_sm *sm_p, job_status_s *js_p);

/* completion function prototypes */
static int create_create_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int create_datafiles_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int create_setattr_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int create_crdirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int create_delete_handles_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);

/* misc helper functions */
static PINT_dist* get_default_distribution(PVFS_fs_id fs_id);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_parent_getattr[];
static union PINT_state_array_values ST_parent_getattr_inspect[];
static union PINT_state_array_values ST_dspace_create_setup_msgpair[];
static union PINT_state_array_values ST_dspace_create_xfer_msgpair[];
static union PINT_state_array_values ST_dspace_create_failure[];
static union PINT_state_array_values ST_datafiles_setup_msgpair_array[];
static union PINT_state_array_values ST_datafiles_xfer_msgpair_array[];
static union PINT_state_array_values ST_datafiles_failure[];
static union PINT_state_array_values ST_create_setattr_setup_msgpair[];
static union PINT_state_array_values ST_create_setattr_xfer_msgpair[];
static union PINT_state_array_values ST_create_setattr_failure[];
static union PINT_state_array_values ST_crdirent_setup_msgpair[];
static union PINT_state_array_values ST_crdirent_xfer_msgpair[];
static union PINT_state_array_values ST_crdirent_failure[];
static union PINT_state_array_values ST_delete_handles_setup_msgpair_array[];
static union PINT_state_array_values ST_delete_handles_xfer_msgpair_array[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_create_sm =
{
	ST_init,
	"pvfs2_client_create_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) "init",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_parent_getattr
};

static union PINT_state_array_values ST_parent_getattr[] = {
(union PINT_state_array_values) "parent_getattr",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_parent_getattr_inspect,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_parent_getattr_inspect[] = {
(union PINT_state_array_values) "parent_getattr_inspect",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_parent_getattr_inspect,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_dspace_create_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_dspace_create_setup_msgpair[] = {
(union PINT_state_array_values) "dspace_create_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_dspace_create_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_dspace_create_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_dspace_create_failure
};

static union PINT_state_array_values ST_dspace_create_xfer_msgpair[] = {
(union PINT_state_array_values) "dspace_create_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_datafiles_setup_msgpair_array,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_dspace_create_failure
};

static union PINT_state_array_values ST_dspace_create_failure[] = {
(union PINT_state_array_values) "dspace_create_failure",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_dspace_create_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_datafiles_setup_msgpair_array[] = {
(union PINT_state_array_values) "datafiles_setup_msgpair_array",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_datafiles_setup_msgpair_array,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_datafiles_xfer_msgpair_array,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_datafiles_xfer_msgpair_array[] = {
(union PINT_state_array_values) "datafiles_xfer_msgpair_array",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_create_setattr_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_datafiles_failure
};

static union PINT_state_array_values ST_datafiles_failure[] = {
(union PINT_state_array_values) "datafiles_failure",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_datafiles_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handles_setup_msgpair_array
};

static union PINT_state_array_values ST_create_setattr_setup_msgpair[] = {
(union PINT_state_array_values) "create_setattr_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_setattr_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_create_setattr_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_create_setattr_xfer_msgpair[] = {
(union PINT_state_array_values) "create_setattr_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_crdirent_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_create_setattr_failure
};

static union PINT_state_array_values ST_create_setattr_failure[] = {
(union PINT_state_array_values) "create_setattr_failure",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_setattr_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handles_setup_msgpair_array
};

static union PINT_state_array_values ST_crdirent_setup_msgpair[] = {
(union PINT_state_array_values) "crdirent_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_crdirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_crdirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_failure
};

static union PINT_state_array_values ST_crdirent_xfer_msgpair[] = {
(union PINT_state_array_values) "crdirent_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_failure
};

static union PINT_state_array_values ST_crdirent_failure[] = {
(union PINT_state_array_values) "crdirent_failure",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_crdirent_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handles_setup_msgpair_array
};

static union PINT_state_array_values ST_delete_handles_setup_msgpair_array[] = {
(union PINT_state_array_values) "delete_handles_setup_msgpair_array",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_delete_handles_setup_msgpair_array,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_delete_handles_xfer_msgpair_array,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_delete_handles_xfer_msgpair_array[] = {
(union PINT_state_array_values) "delete_handles_xfer_msgpair_array",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_create_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_cleanup,
(union PINT_state_array_values) CREATE_RETRY,
(union PINT_state_array_values) ST_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 221 "src/client/sysint/sys-create.sm"


/** Initiate creation of a file with a specified distribution.
 */
PVFS_error PVFS_isys_create(
    char *object_name,
    PVFS_object_ref parent_ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sys_dist *dist,
    PVFS_sysresp_create *resp,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    int num_dfiles_req = 0;
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_create entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) ||
        (object_name == NULL) || (resp == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    if ((attr.mask & PVFS_ATTR_SYS_ALL_SETABLE) !=
        PVFS_ATTR_SYS_ALL_SETABLE)
    {
        gossip_lerr("PVFS_isys_create() failure: invalid attributes "
                    "specified\n");
        return ret;
    }

    if ((attr.mask & PVFS_ATTR_SYS_DFILE_COUNT) &&
        ((attr.dfile_count < 1) ||
         (attr.dfile_count > PVFS_REQ_LIMIT_DFILE_COUNT)))
    {
	gossip_err("Error: invalid number of datafiles (%d) specified "
                   "in PVFS_sys_create().\n", (int)attr.dfile_count);
	return ret;
    }

    if ((strlen(object_name) + 1) > PVFS_REQ_LIMIT_SEGMENT_BYTES)
    {
        return -PVFS_ENAMETOOLONG;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.create.object_name = object_name;
    sm_p->u.create.create_resp = resp;
    sm_p->u.create.datafile_handles = NULL;
    PVFS_util_copy_sys_attr(&sm_p->u.create.sys_attr, &attr);
    sm_p->u.create.stored_error_code = 0;
    sm_p->u.create.retry_count = 0;

    sm_p->object_ref = parent_ref;

    /* If the user specifies a distribution use that
       else, use the default distribution */
    if (dist)
    {
        if (!dist->name)
        {
            free(sm_p);
            return -PVFS_EINVAL;
        }

        sm_p->u.create.dist = PINT_dist_create(dist->name);
        if (!sm_p->u.create.dist)
        {
            free(sm_p);
            return -PVFS_ENOMEM;
        }
        sm_p->u.create.dist->params = dist->params;
    }
    else
    {
        /* Get the default distribution */
        sm_p->u.create.dist = get_default_distribution(sm_p->parent_ref.fs_id);
        if (!sm_p->u.create.dist)
        {
            free(sm_p);
            return -PVFS_ENOMEM;
        }
    }
    
    /* If an application hint has been provided, use that to request dfile
       else, if a tabfile hint has been provided, use that instead*/
    num_dfiles_req = 0;
    if (attr.mask & PVFS_ATTR_SYS_DFILE_COUNT)
    {
        num_dfiles_req = attr.dfile_count;
    }
    else
    {
        /* Check the mount options */
        int rc;
        struct PVFS_sys_mntent mntent;

        rc = PVFS_util_get_mntent_copy(sm_p->object_ref.fs_id, &mntent);
        if (0 == rc)
        {
            num_dfiles_req = mntent.default_num_dfiles;
        }
    }

    /* Determine the number of dfiles, passing in client hints to
       override any server hints */
    ret = PINT_cached_config_get_num_dfiles(sm_p->object_ref.fs_id,
                                            sm_p->u.create.dist,
                                            num_dfiles_req,
                                            &sm_p->u.create.num_data_files);

    if (ret < 0)
    {
        gossip_err("Failed to get number of data servers\n");
        free(sm_p);
        return ret;
    }

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Creating file %s under %llu, %d\n",
        object_name, llu(parent_ref.handle), parent_ref.fs_id);
          
    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_CREATE, op_id, user_ptr);
}

/** Create a file with a specified distribution.
 */
PVFS_error PVFS_sys_create(
    char *object_name,
    PVFS_object_ref parent_ref,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sys_dist *dist,
    PVFS_sysresp_create *resp)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_create entered\n");

    ret = PVFS_isys_create(object_name, parent_ref, attr, credentials,
                           dist, resp, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_create call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "create", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

/****************************************************************/

static int create_init(PINT_client_sm *sm_p,
		       job_status_s *js_p)
{
    job_id_t tmp_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: init\n");

    assert((js_p->error_code == 0) ||
           (js_p->error_code == CREATE_RETRY));

    if (js_p->error_code == CREATE_RETRY)
    {
        js_p->error_code = 0;

        return job_req_sched_post_timer(
            sm_p->msgarray_params.retry_delay, sm_p, 0, js_p, &tmp_id,
            pint_client_sm_context);
    }

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_COMMON_ALL, 
        PVFS_TYPE_DIRECTORY,
        0);

   return 1;
}

static int create_create_comp_fn(void *v_p,
                                 struct PVFS_server_resp *resp_p,
                                 int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG, "create_create_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_CREATE);

    if (resp_p->status != 0)
    {
	return resp_p->status;
    }

    /* otherwise, just stash the newly created meta handle */
    sm_p->u.create.metafile_handle = resp_p->u.create.handle;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "*** Got newly created handle %llu\n",
        llu(sm_p->u.create.metafile_handle));

    return 0;
}

static int create_datafiles_comp_fn(void *v_p,
                                    struct PVFS_server_resp *resp_p,
                                    int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create_datafiles_comp_fn[%d]\n",index);

    assert(resp_p->op == PVFS_SERV_CREATE);

    if (resp_p->status != 0)
    {
        gossip_err("%s: Failed to create data handle %d\n", __func__, index);
        PVFS_perror_gossip("Creation failure", resp_p->status);
	return resp_p->status;
    }

    /* allocate memory for the data handles if we haven't already */
    if (sm_p->u.create.datafile_handles == NULL)
    {
        sm_p->u.create.datafile_handles = (PVFS_handle *)malloc(
            sm_p->u.create.num_data_files * sizeof(PVFS_handle));

        if (sm_p->u.create.datafile_handles == NULL)
        {
            gossip_err("create: Failed to allocate data handle array\n");
            return -PVFS_ENOMEM;
        }
        memset(sm_p->u.create.datafile_handles, 0,
               sm_p->u.create.num_data_files * sizeof(PVFS_handle));
    }

    /* otherwise, just stash the newly created data file handle */
    sm_p->u.create.datafile_handles[index] = resp_p->u.create.handle;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "Datafile handle %d is %llu\n",
                 index, llu(sm_p->u.create.datafile_handles[index]));
    return 0;
}

static int create_setattr_comp_fn(void *v_p,
                                  struct PVFS_server_resp *resp_p,
                                  int index)
{
    int res;
    PVFS_object_ref refn;
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    PVFS_size tmp_size = 0;
    gossip_debug(GOSSIP_CLIENT_DEBUG, "create_setattr_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_SETATTR);

    refn.fs_id = sm_p->msgpair.fs_id;
    refn.handle = sm_p->msgpair.handle;

    /* insert a cache entry, set size to 0 */
    res = PINT_acache_update(refn, 
        &sm_p->msgpair.req.u.setattr.attr,
        &tmp_size);
    if(res != 0)
    {
        return res;
    }

    return resp_p->status;
}

static int create_crdirent_comp_fn(void *v_p,
                                   struct PVFS_server_resp *resp_p,
                                   int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "create_crdirent_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_CRDIRENT);
    return resp_p->status;
}

static int create_delete_handles_comp_fn(void *v_p,
                                         struct PVFS_server_resp *resp_p,
                                         int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "create_delete_handles_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_REMOVE);

    if (resp_p->status != 0)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG,
                     "Failed to remove handle number %d\n", index);
    }
    return resp_p->status;
}

static int create_dspace_create_setup_msgpair(PINT_client_sm *sm_p,
                                              job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_handle_extent_array meta_handle_extent_array;
    PINT_sm_msgpair_state *msg_p = NULL;
    struct server_configuration_s *server_config = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: "
                 "dspace_create_setup_msgpair\n");

    js_p->error_code = 0;

    if (sm_p->u.create.num_data_files > PVFS_REQ_LIMIT_DFILE_COUNT)
    {
        sm_p->u.create.num_data_files = PVFS_REQ_LIMIT_DFILE_COUNT;
        gossip_err("Warning: reducing number of data "
                     "files to PVFS_REQ_LIMIT_DFILE_COUNT\n");
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG, "need to create %d datafiles\n",
                 sm_p->u.create.num_data_files);

    gossip_debug(GOSSIP_CLIENT_DEBUG," create: posting create req\n");

    PINT_init_msgpair(sm_p, msg_p);

    server_config = PINT_get_server_config_struct(
        sm_p->object_ref.fs_id);

    ret = PINT_cached_config_get_next_meta(
        server_config, sm_p->object_ref.fs_id,
        &msg_p->svr_addr, &meta_handle_extent_array);

    PINT_put_server_config_struct(server_config);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
        return 1;
    }

    PINT_SERVREQ_CREATE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        PVFS_TYPE_METAFILE,
        meta_handle_extent_array);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = meta_handle_extent_array.extent_array[0].first;
    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
    msg_p->comp_fn = create_create_comp_fn;

    return 1;
}

static int create_dspace_create_failure(PINT_client_sm *sm_p,
					job_status_s *js_p)
{
    sm_p->u.create.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create state: dspace_create_failure\n");
    return 1;
}

static int create_datafiles_setup_msgpair_array(PINT_client_sm *sm_p,
                                                job_status_s *js_p)
{
    int ret = -PVFS_EINVAL, i = 0;
    struct server_configuration_s *server_config = NULL;
    int server_type;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: "
                 "datafiles_setup_msgpair_array\n");

    js_p->error_code = 0;

    memset(&sm_p->msgpair, 0, sizeof(PINT_sm_msgpair_state));

    /* allocate msgarray and set msgarray_count */
    if (sm_p->msgarray && (sm_p->msgarray != &(sm_p->msgpair)))
    {
        free(sm_p->msgarray);
    }
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        (sm_p->u.create.num_data_files *
         sizeof(PINT_sm_msgpair_state)));
    if (sm_p->msgarray == NULL)
    {
        gossip_err("create: failed to allocate msgarray\n");
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }
    sm_p->msgarray_count = sm_p->u.create.num_data_files;

    /* allocate handle extent array objects */
    if (sm_p->u.create.io_handle_extent_array == NULL)
    {
        sm_p->u.create.io_handle_extent_array = (PVFS_handle_extent_array *)
            malloc(sm_p->u.create.num_data_files *
                   sizeof(PVFS_handle_extent_array));
    }
    if (!sm_p->u.create.io_handle_extent_array)
    {
        gossip_err("create: failed to allocate handle_extent_array\n"); 
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    /* allocate data server bmi address array */
    if (sm_p->u.create.data_server_addrs == NULL)
    {
        sm_p->u.create.data_server_addrs = (PVFS_BMI_addr_t *)malloc(
            sm_p->u.create.num_data_files * sizeof(PVFS_BMI_addr_t));
    }
    if (!sm_p->u.create.data_server_addrs)
    {
        gossip_err("create: failed to allocate data server addrs\n"); 
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    server_config = PINT_get_server_config_struct(
        sm_p->object_ref.fs_id);

    ret = PINT_cached_config_get_next_io(
        server_config,
        sm_p->object_ref.fs_id,
        sm_p->u.create.num_data_files,
        sm_p->u.create.data_server_addrs,
        sm_p->u.create.io_handle_extent_array);

    PINT_put_server_config_struct(server_config);

    if (ret)
    {
        gossip_err("Failed to retrieve data server addresses\n");
        js_p->error_code = ret;
        return 1;
    }
    
    /* for each datafile, prepare to post a create send/recv pair */
    for(i = 0; i < sm_p->u.create.num_data_files; i++)
    {
        PINT_sm_msgpair_state *msg_p = &sm_p->msgarray[i];

        PINT_SERVREQ_CREATE_FILL(
            msg_p->req,
            *sm_p->cred_p,
            sm_p->object_ref.fs_id,
            PVFS_TYPE_DATAFILE,
            sm_p->u.create.io_handle_extent_array[i]);

        gossip_debug(GOSSIP_CLIENT_DEBUG,  "posting datafile[%d] create "
                     "with extents %llu-%llu\n", i,
                     llu(sm_p->u.create.io_handle_extent_array[i].
                        extent_array[0].first),
                     llu(sm_p->u.create.io_handle_extent_array[i].
                        extent_array[0].last));

        msg_p->fs_id = sm_p->object_ref.fs_id;
        msg_p->handle = sm_p->u.create.io_handle_extent_array[i].
            extent_array[0].first;
        msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
        msg_p->comp_fn = create_datafiles_comp_fn;
        msg_p->svr_addr = sm_p->u.create.data_server_addrs[i];

        gossip_debug(GOSSIP_VARSTRIP_DEBUG, 
                     "Data file number: %d - Server name: %s\n",
                     i, PVFS_mgmt_map_addr(msg_p->fs_id, sm_p->cred_p,
                                           msg_p->svr_addr, &server_type));
    }
    return 1;
}

static int create_datafiles_failure(PINT_client_sm *sm_p,
                                    job_status_s *js_p)
{
    sm_p->u.create.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create state: datafiles_failure\n");
    return 1;
}

static int create_setattr_setup_msgpair(PINT_client_sm *sm_p,
                                        job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create state: setattr_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," create: posting setattr req\n");

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_SETATTR_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->u.create.metafile_handle,
        PVFS_TYPE_METAFILE,
        sm_p->u.create.sys_attr,
        (PVFS_ATTR_COMMON_TYPE | PVFS_ATTR_META_ALL));

    msg_p->req.u.setattr.attr.u.meta.dfile_array =
        sm_p->u.create.datafile_handles;
    msg_p->req.u.setattr.attr.u.meta.dfile_count =
        sm_p->u.create.num_data_files;
    msg_p->req.u.setattr.attr.u.meta.dist =
        sm_p->u.create.dist;
    msg_p->req.u.setattr.attr.u.meta.dist_size =
        PINT_DIST_PACK_SIZE(sm_p->u.create.dist);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->u.create.metafile_handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = create_setattr_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int create_setattr_failure(PINT_client_sm *sm_p,
                                  job_status_s *js_p)
{
    sm_p->u.create.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create state: setattr_failure\n");
    return 1;
}

static int create_crdirent_setup_msgpair(PINT_client_sm *sm_p,
					 job_status_s *js_p)
{
    int ret = -1;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "create state: crdirent_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," create: posting crdirent req\n");

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_CRDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->u.create.object_name,
        sm_p->u.create.metafile_handle,
        sm_p->object_ref.handle,
        sm_p->object_ref.fs_id,
        sm_p->u.create.sys_attr.atime,
        sm_p->u.create.sys_attr.mtime,
        sm_p->u.create.sys_attr.ctime);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = create_crdirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, sm_p->object_ref.handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int create_crdirent_failure(PINT_client_sm *sm_p,
				   job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: crdirent_failure\n");

    sm_p->u.create.stored_error_code = js_p->error_code;

    if (sm_p->u.create.stored_error_code == -PVFS_EEXIST)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG, "crdirent failed: "
                     "dirent already exists!\n");
    }
    return 1;
}

/* delete the newly created meta and data handles */
static int create_delete_handles_setup_msgpair_array(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL, i = 0, actual_count = 0;
    PVFS_BMI_addr_t metafile_server_addr;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: "
                 "delete_handles_setup_msgpair_array\n");

    js_p->error_code = 0;

    memset(&sm_p->msgpair, 0, sizeof(PINT_sm_msgpair_state));

    ret = PINT_cached_config_map_to_server(
        &metafile_server_addr, sm_p->u.create.metafile_handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
        return 1;
    }

    /*
      in the case that all datafiles have already been created,
      actual_count will be (sm_p->u.create.num_data_files + 1).
      otherwise, it will be somewhere between 1 (for the metafile) and
      1 + the number of data files
    */
    actual_count = 1;
    for(i = 0; i < sm_p->u.create.num_data_files; i++)
    {
        if (sm_p->u.create.datafile_handles &&
            (sm_p->u.create.datafile_handles[i] != PVFS_HANDLE_NULL))
        {
            actual_count++;
        }
    }

    if (sm_p->msgarray && (sm_p->msgarray != &(sm_p->msgpair)))
    {
        free(sm_p->msgarray);
    }
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        (actual_count * sizeof(PINT_sm_msgpair_state)));

    if (sm_p->msgarray == NULL)
    {
        gossip_err("create: failed to allocate msgarray\n"); 
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }
    sm_p->msgarray_count = actual_count;

    assert(sm_p->u.create.data_server_addrs);

    /*
      for the metafile and each datafile, prepare to post a remove
      send/recv pair
    */
    for(i = 0; i < actual_count; i++)
    {
        PINT_sm_msgpair_state *msg_p = &sm_p->msgarray[i];

        gossip_debug(GOSSIP_CLIENT_DEBUG,
                     "create: posting data file remove req %d\n",i);

        /* arbitrarily handle deletion of the metafile last */
        if (i == (actual_count - 1))
        {
            PINT_SERVREQ_REMOVE_FILL(
                msg_p->req,
                *sm_p->cred_p,
                sm_p->object_ref.fs_id,
                sm_p->u.create.metafile_handle);

            msg_p->fs_id = sm_p->object_ref.fs_id;
            msg_p->handle = sm_p->u.create.metafile_handle;
            msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
            msg_p->comp_fn = create_delete_handles_comp_fn;
            msg_p->svr_addr = metafile_server_addr;

            gossip_debug(GOSSIP_CLIENT_DEBUG, " Preparing to remove "
                         "metafile handle %llu\n", llu(msg_p->handle));
        }
        else
        {
            PINT_SERVREQ_REMOVE_FILL(
                msg_p->req,
                *sm_p->cred_p,
                sm_p->object_ref.fs_id,
                sm_p->u.create.datafile_handles[i]);

            msg_p->fs_id = sm_p->object_ref.fs_id;
            msg_p->handle = sm_p->u.create.datafile_handles[i];
            msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
            msg_p->comp_fn = create_delete_handles_comp_fn;
            msg_p->svr_addr = sm_p->u.create.data_server_addrs[i];

            gossip_debug(GOSSIP_CLIENT_DEBUG, " Preparing to remove "
                         "datafile handle %llu\n", llu(msg_p->handle));
        }
    }
    return 1;
}

static int create_cleanup(PINT_client_sm *sm_p,
                          job_status_s *js_p)
{
    PVFS_object_ref metafile_ref;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: cleanup\n");

    PVFS_util_release_sys_attr(&sm_p->u.create.sys_attr);

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    sm_p->error_code = (sm_p->u.create.stored_error_code ?
                        sm_p->u.create.stored_error_code :
                        js_p->error_code);

    if (sm_p->error_code == 0)
    {
        metafile_ref.handle = sm_p->u.create.metafile_handle;
        metafile_ref.fs_id = sm_p->object_ref.fs_id;

        /* fill in outgoing response fields */
        sm_p->u.create.create_resp->ref = metafile_ref;

        /* insert newly created metafile into the ncache */
        PINT_ncache_insert(sm_p->u.create.object_name,
                           0 /* PVFS2_LOOKUP_LINK_NO_FOLLOW */,
                           metafile_ref, sm_p->object_ref);
    }
    else if ((PVFS_ERROR_CLASS(-sm_p->error_code) == PVFS_ERROR_BMI) &&
             (sm_p->u.create.retry_count < sm_p->msgarray_params.retry_limit))
    {
        sm_p->u.create.stored_error_code = 0;
        sm_p->u.create.retry_count++;

        gossip_debug(GOSSIP_CLIENT_DEBUG, "Retrying create operation "
                     "(attempt number %d)\n", sm_p->u.create.retry_count);

        js_p->error_code = CREATE_RETRY;
        return 1;
    }
    else
    {
        PINT_acache_invalidate(sm_p->object_ref);
    }

    if (sm_p->u.create.io_handle_extent_array)
    {
        free(sm_p->u.create.io_handle_extent_array);
        sm_p->u.create.io_handle_extent_array = NULL;
    }

    if (sm_p->u.create.data_server_addrs)
    {
        free(sm_p->u.create.data_server_addrs);
        sm_p->u.create.data_server_addrs = NULL;
    }

    if (sm_p->u.create.datafile_handles)
    {
        free(sm_p->u.create.datafile_handles);
        sm_p->u.create.datafile_handles = NULL;
    }

    if (sm_p->u.create.dist)
    {
        PINT_dist_free(sm_p->u.create.dist);
        sm_p->u.create.dist = NULL;
    }

    if (sm_p->msgarray != &(sm_p->msgpair))
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    sm_p->op_complete = 1;
    return 0;
}

/** looks at the attributes of the parent directory and decides if it impacts
 *  the file creation in any way
 */
static int create_parent_getattr_inspect(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    PVFS_object_attr *attr = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "create state: parent_getattr_inspect\n");

    attr = &sm_p->getattr.attr;
    assert(attr);

    gossip_debug(GOSSIP_CLIENT_DEBUG, "parent owner: %d, group: %d, perms: %d\n",
        (int)attr->owner, (int)attr->group, (int)attr->perms);

    /* do we have a setgid bit? */
    if(attr->perms & PVFS_G_SGID)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG, "parent has setgid bit set.\n");
        gossip_debug(GOSSIP_CLIENT_DEBUG, " - modifying requested attr "
                                          "for new file.\n");
        sm_p->u.create.sys_attr.group = attr->group;
        /* note that permission checking is left to server even in this case */
    }

    return(1);
}

/**
 * Returns the default distribution, or NULL if the distribution could not
 * be created.  The default distribution is read from the server
 * configuration if possible.  If the server config does not specify a
 * default distribution, simple_stripe will be used.
 */
static PINT_dist* get_default_distribution(PVFS_fs_id fs_id)
{
    server_configuration_s* server_config = NULL;
    PINT_dist* dist = NULL;

    /* Retrieve the server configuration (with mutex) */
    server_config = PINT_get_server_config_struct(fs_id);

    /* If a default dist is specified in the config, use that
       else just create a simple_stripe distribution */
    if (NULL != server_config &&
        NULL != server_config->default_dist_config.name)
    {
        dist = PINT_dist_create(server_config->default_dist_config.name);
        
        if (dist)
        {
            PINT_llist_p iter = server_config->default_dist_config.param_list;

            /* Set supplied the distribution parameters */
            while (iter)
            {
                int rc;
                distribution_param_configuration* param =PINT_llist_head(iter);

                /* If we are at the list end, break
                   else, set the distribution parameter to the given value */
                if (NULL == param)
                {
                    break;
                }
                else
                {
                    rc = dist->methods->set_param(dist->dist_name,
                                                  dist->params,
                                                  param->name,
                                                  &param->value);

                    if (0 != rc)
                    {
                        gossip_err("Error setting distribution parameter\n"
                                   "  dist: %s\n"
                                   "  param name: %s\n"
                                   "  param value: %lld\n",
                                   dist->dist_name, param->name,
                                   lld(param->value));
                    }
                }
                iter = PINT_llist_next(iter);
            }                
        }
        else
        {
            gossip_err("Error creating default distribution: %s\n",
                       server_config->default_dist_config.name);
        }
    }
    else
    {
        dist = PINT_dist_create(PVFS_DIST_SIMPLE_STRIPE_NAME);
    }

    /* Release the server config mutex */
    PINT_put_server_config_struct(server_config);

    return dist;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
