/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "pvfs2-internal.h"

extern job_context_id pint_client_sm_context;

enum
{
    REMOVE_MUST_REMOVE_DATAFILES = 1,
    MSGPAIR_RETURN_SUCCESS
};

static int remove_getattr_init(PINT_client_sm *sm_p,
                               job_status_s *js_p);
static int remove_getattr_analyze_results(PINT_client_sm *sm_p,
                                          job_status_s *js_p);
static int remove_datafile_remove_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_datafile_remove_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_object_remove_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_object_remove_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int remove_helper_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

#define HANDLE_REMOVE_ERROR(state)                                     \
do {                                                                   \
    char buf[64] = {0};                                                \
    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: %s\n", state);    \
    PVFS_strerror_r(js_p->error_code, buf, 64);                        \
    gossip_err("WARNING: PVFS_sys_remove() encountered an error which "\
               "may lead\n  to inconsistent state: %s\n", buf);        \
    gossip_err("WARNING: PVFS2 fsck (if available) may be needed.\n"); \
    sm_p->u.remove.stored_error_code = js_p->error_code;               \
    js_p->error_code = 0;                                              \
} while(0)

static union PINT_state_array_values ST_getattr_init[];
static union PINT_state_array_values ST_getattr[];
static union PINT_state_array_values ST_getattr_analyze_results[];
static union PINT_state_array_values ST_datafile_remove_setup_msgpair[];
static union PINT_state_array_values ST_datafile_remove_xfer_msgpair[];
static union PINT_state_array_values ST_datafile_remove_failure[];
static union PINT_state_array_values ST_object_remove_setup_msgpair[];
static union PINT_state_array_values ST_object_remove_xfer_msgpair[];
static union PINT_state_array_values ST_object_remove_failure[];
static union PINT_state_array_values ST_remove_helper_cleanup[];

struct PINT_state_machine_s pvfs2_client_remove_helper_sm =
{
	ST_getattr_init,
	"pvfs2_client_remove_helper_sm"
};
static union PINT_state_array_values ST_getattr_init[] = {
(union PINT_state_array_values) "getattr_init",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_getattr_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_getattr
};

static union PINT_state_array_values ST_getattr[] = {
(union PINT_state_array_values) "getattr",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_getattr_analyze_results,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_helper_cleanup
};

static union PINT_state_array_values ST_getattr_analyze_results[] = {
(union PINT_state_array_values) "getattr_analyze_results",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_getattr_analyze_results,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_object_remove_setup_msgpair,
(union PINT_state_array_values) REMOVE_MUST_REMOVE_DATAFILES,
(union PINT_state_array_values) ST_datafile_remove_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_helper_cleanup
};

static union PINT_state_array_values ST_datafile_remove_setup_msgpair[] = {
(union PINT_state_array_values) "datafile_remove_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_datafile_remove_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_datafile_remove_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_datafile_remove_failure
};

static union PINT_state_array_values ST_datafile_remove_xfer_msgpair[] = {
(union PINT_state_array_values) "datafile_remove_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_object_remove_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_datafile_remove_failure
};

static union PINT_state_array_values ST_datafile_remove_failure[] = {
(union PINT_state_array_values) "datafile_remove_failure",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_datafile_remove_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_helper_cleanup
};

static union PINT_state_array_values ST_object_remove_setup_msgpair[] = {
(union PINT_state_array_values) "object_remove_setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_object_remove_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_object_remove_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_object_remove_failure
};

static union PINT_state_array_values ST_object_remove_xfer_msgpair[] = {
(union PINT_state_array_values) "object_remove_xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_helper_cleanup,
(union PINT_state_array_values) MSGPAIR_RETURN_SUCCESS,
(union PINT_state_array_values) ST_remove_helper_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_object_remove_failure
};

static union PINT_state_array_values ST_object_remove_failure[] = {
(union PINT_state_array_values) "object_remove_failure",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_object_remove_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_helper_cleanup
};

static union PINT_state_array_values ST_remove_helper_cleanup[] = {
(union PINT_state_array_values) "remove_helper_cleanup",
(union PINT_state_array_values) &pvfs2_client_remove_helper_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_helper_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

# 139 "src/client/sysint/remove.sm"


static int remove_getattr_init(PINT_client_sm *sm_p,
                               job_status_s *js_p)
{
    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_META_ALL|PVFS_ATTR_COMMON_TYPE,
        PVFS_TYPE_NONE,
        0);
    return 1;
}

static int remove_getattr_analyze_results(PINT_client_sm *sm_p,
                                          job_status_s *js_p)
{
    PVFS_object_attr *attr = NULL;
    attr = &sm_p->getattr.attr;
    assert(attr);

    switch(attr->objtype)
    {
	case PVFS_TYPE_METAFILE:
	    assert(attr->mask & PVFS_ATTR_META_DFILES);
	    assert(attr->u.meta.dfile_count > 0);

	    gossip_debug(
                GOSSIP_CLIENT_DEBUG,
                "remove_getattr_comp_fn: must remove %d datafiles\n",
                attr->u.meta.dfile_count);

	    js_p->error_code = REMOVE_MUST_REMOVE_DATAFILES;
            break;
	case PVFS_TYPE_DIRECTORY:
#if 0
/* NOTE: this check is not safe because it relies on cached attributes on the
 * parent, which may be out of date.  The server will perform this check
 * locally when we attempt to remove the directory itself.
 */
            if(attr->u.dir.dirent_count != 0)
            {
                js_p->error_code = -PVFS_ENOTEMPTY;
                break;
            }
#endif
	case PVFS_TYPE_SYMLINK:
            js_p->error_code = 0;
            break;
	case PVFS_TYPE_DATAFILE:
	case PVFS_TYPE_DIRDATA:
	default:
	    gossip_err("error: remove_getattr_comp_fn: unhandled "
                       "object type (%x)\n",
                       attr->objtype);
    }
    return 1;
}

static int remove_datafile_remove_setup_msgpair(PINT_client_sm *sm_p,
						job_status_s *js_p)
{
    int i = 0;
    int ret = -PVFS_EINVAL;
    PVFS_object_attr *attr = NULL;

   /* post all datafile remove requests and responses simultaneously.
    *
    * NOTE: it's easier to clean up from a metafile with no datafiles
    * than the other way around!  so we remove datafiles first.
    */
    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: datafile_remove_setup_msgpair\n");

    attr = &sm_p->getattr.attr;
    assert(attr);

    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        attr->u.meta.dfile_count * sizeof(PINT_sm_msgpair_state));
    if (!sm_p->msgarray)
    {
	js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }
    sm_p->msgarray_count = attr->u.meta.dfile_count;
    
    /* for each datafile, post a send/recv pair for the remove */
    for (i = 0; i < attr->u.meta.dfile_count; i++)
    {
	PINT_sm_msgpair_state *msg_p = &sm_p->msgarray[i];

	gossip_debug(GOSSIP_CLIENT_DEBUG,
		     "  datafile_remove: removing handle %llu\n",
		     llu(attr->u.meta.dfile_array[i]));

	PINT_SERVREQ_REMOVE_FILL(
            msg_p->req,
            *sm_p->cred_p,
            sm_p->object_ref.fs_id,
            attr->u.meta.dfile_array[i]);

	msg_p->fs_id = sm_p->object_ref.fs_id;
	msg_p->handle = attr->u.meta.dfile_array[i];
        msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
	msg_p->comp_fn = NULL;
    }

    /* fill in address of each server to contact */
    ret =  PINT_serv_msgpairarray_resolve_addrs(
        sm_p->msgarray_count, sm_p->msgarray);

    if (ret < 0)
    {
	gossip_err("Error: failed to resolve server addresses.\n");
	js_p->error_code = ret;
    }
    return 1;
}

static int remove_object_remove_setup_msgpair(PINT_client_sm *sm_p,
					      job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "remove state: object_remove_setup_msgpair\n");

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_REMOVE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->object_ref.handle);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
    msg_p->comp_fn = NULL;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
	js_p->error_code = ret;
    }
    return 1;    
}

static int remove_datafile_remove_failure(PINT_client_sm *sm_p,
					  job_status_s *js_p)
{
    HANDLE_REMOVE_ERROR("datafile_remove_failure");
    return 1;
}

static int remove_object_remove_failure(PINT_client_sm *sm_p,
					job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: "
                 "object_remove_failure\n");
    /*
      catch and return acceptable errors here to avoid generic
      post-remove-failure cleanup
    */
    if (js_p->error_code == -PVFS_ENOTEMPTY)
    {
        gossip_debug(GOSSIP_CLIENT_DEBUG, " directory not empty -- "
                     "returning error\n");
    }
    else
    {
        HANDLE_REMOVE_ERROR("object_remove_failure");
    }
    return 1;
}

static int remove_helper_cleanup(PINT_client_sm *sm_p,
                                 job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "remove state: helper cleanup\n");

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    PINT_acache_invalidate(sm_p->object_ref);

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    if (js_p->error_code)
    {
        char buf[64] = {0};
        PVFS_strerror_r(js_p->error_code, buf, 64);
        gossip_debug(GOSSIP_CLIENT_DEBUG,
                     "remove_helper_cleanup error: %s\n", buf);
    }
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
