/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for setting run-time parameters
 *  on a list of servers.  These are currently used primarily for file
 *  system repair purposes, specifically to put the servers in a special
 *  administrative mode to avoid file system changes while repairs are
 *  underway.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

/* state function prototypes */
static int mgmt_setparam_list_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_setparam_list_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int root_check_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);
static int collect_old_values_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_setparam_list_sm =
{
	ST_setup_msgpair,
	"pvfs2_client_mgmt_setparam_list_sm"
};
static union PINT_state_array_values ST_setup_msgpair[] = {
(union PINT_state_array_values) "setup_msgpair",
(union PINT_state_array_values) &pvfs2_client_mgmt_setparam_list_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_setparam_list_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
(union PINT_state_array_values) "xfer_msgpair",
(union PINT_state_array_values) &pvfs2_client_mgmt_setparam_list_sm,
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) "cleanup",
(union PINT_state_array_values) &pvfs2_client_mgmt_setparam_list_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_setparam_list_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 69 "src/client/sysint/mgmt-setparam-list.sm"


/** Initiate setting of a run-time server parameter on a list of servers.
 */
PVFS_error PVFS_imgmt_setparam_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    enum PVFS_server_param param,
    uint64_t value,
    PVFS_BMI_addr_t *addr_array,
    uint64_t *old_value_array,
    int count,
    PVFS_error_details *details,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_setparam_list entered\n");

    if (param == PVFS_SERV_PARAM_INVALID)
    {
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.setparam_list.fs_id = fs_id;
    sm_p->u.setparam_list.param = param;
    sm_p->u.setparam_list.value = value;
    sm_p->u.setparam_list.addr_array = addr_array;
    sm_p->u.setparam_list.old_value_array = old_value_array;
    sm_p->u.setparam_list.count = count;
    sm_p->u.setparam_list.details = details;

    sm_p->msgarray_count = count;
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        count * sizeof(PINT_sm_msgpair_state));
    if (sm_p->msgarray == NULL)
    {
        free(sm_p);
        return -PVFS_ENOMEM;
    }

    if (sm_p->u.setparam_list.root_check_status_array)
    {
        free(sm_p->u.setparam_list.root_check_status_array);
        sm_p->u.setparam_list.root_check_status_array = NULL;
    }

    if (old_value_array != NULL)
    {
        memset(old_value_array, 0, (count * sizeof(uint64_t)));
    }

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_SETPARAM_LIST, op_id, user_ptr);
}

/** Set a run-time parameter on a list of servers.
 */
PVFS_error PVFS_mgmt_setparam_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    enum PVFS_server_param param,
    uint64_t value,
    PVFS_BMI_addr_t *addr_array,
    uint64_t *old_value_array,
    int count,
    PVFS_error_details *details)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_mgmt_setparam entered\n");

    ret = PVFS_imgmt_setparam_list(
        fs_id, credentials, param, value, addr_array, old_value_array,
        count, details, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_setparam_list call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_mgmt_wait(op_id, "setparam_list", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_setparam_list completed\n");

    PINT_mgmt_release(op_id);
    return error;
}

static int mgmt_setparam_list_setup_msgpair(PINT_client_sm *sm_p,
                                            job_status_s *js_p)
{
    int i = 0;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "setparam_list state: "
                 "mgmt_setparam_list_setup_msgpair\n");

    /* setup msgpair array */
    for (i=0; i < sm_p->msgarray_count; i++)
    {
        msg_p = &sm_p->msgarray[i];

        PINT_SERVREQ_MGMT_SETPARAM_FILL(
            msg_p->req,
            *sm_p->cred_p,
            sm_p->u.setparam_list.fs_id,
            sm_p->u.setparam_list.param,
            sm_p->u.setparam_list.value);
        
        msg_p->fs_id = sm_p->u.setparam_list.fs_id;
        msg_p->handle = PVFS_HANDLE_NULL;
        msg_p->retry_flag = PVFS_MSGPAIR_RETRY;

        switch(sm_p->u.setparam_list.param)
        {
            case PVFS_SERV_PARAM_ROOT_CHECK:
                msg_p->comp_fn = root_check_comp_fn;
                sm_p->u.setparam_list.root_check_status_array = (int *)
                    malloc(sm_p->u.setparam_list.count * sizeof(int));
                memset(sm_p->u.setparam_list.root_check_status_array, -1,
                       (sm_p->u.setparam_list.count * sizeof(int)));
                break;

            default:
                msg_p->comp_fn = collect_old_values_comp_fn;
                break;
        }
        msg_p->svr_addr = sm_p->u.setparam_list.addr_array[i];
    }

    /* immediate return: next state jumps to msgpairarray machine */
    js_p->error_code = 0;
    return 1;
}

static int mgmt_setparam_list_cleanup(PINT_client_sm *sm_p,
                                      job_status_s *js_p)
{
    int i = 0, errct = 0;
    PVFS_error error = js_p->error_code;

    /* store server-specific errors if requested and present */
    if ((error != 0) && (sm_p->u.setparam_list.details != NULL))
    {
        sm_p->u.setparam_list.details->count_exceeded = 0;

        for(i = 0; i < sm_p->u.setparam_list.count; i++)
        {
            int status;
            if (sm_p->u.setparam_list.param == PVFS_SERV_PARAM_ROOT_CHECK)
            {
                status = sm_p->u.setparam_list.root_check_status_array[i];
            }
            else
            {
                status = sm_p->msgarray[i].op_status;
            }

            if (errct < sm_p->u.setparam_list.details->count_allocated)
            {
                sm_p->u.setparam_list.details->error[errct].error = status;
                sm_p->u.setparam_list.details->error[errct].addr =
                    sm_p->msgarray[i].svr_addr;
                errct++;
            }
            else
            {
                sm_p->u.setparam_list.details->count_exceeded = 1;
                break;
            }
        }
        sm_p->u.setparam_list.details->count_used = errct;

        error = -PVFS_EDETAIL;
    }

    if(sm_p->u.setparam_list.param == PVFS_SERV_PARAM_ROOT_CHECK)
    {
        free(sm_p->u.setparam_list.root_check_status_array);
        sm_p->u.setparam_list.root_check_status_array = NULL;
    }

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
        free(sm_p->msgarray);
    }

    sm_p->error_code  = error;
    sm_p->op_complete = 1;

    return 0;
}

/* collect_old_values_comp_fn()
 *
 * completion function that assembles old values for parameters
 * when appropriate
 *
 * returns 0 on success, -PVFS_error on failure
 */
static int collect_old_values_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i)
{
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;
    int j;

    if ((sm_p->msgarray[i].op_status == 0) &&
        (sm_p->u.setparam_list.old_value_array))
    {
        sm_p->u.setparam_list.old_value_array[i] =
            resp_p->u.mgmt_setparam.old_value;
    }
 
    /* if this is the last response, check all of the status values
     * and return error code if any requests failed
     */
    if (i == (sm_p->msgarray_count -1))
    {
        for (j = 0; j < sm_p->msgarray_count; j++)
        {
            if (sm_p->msgarray[j].op_status != 0)
            {
                return sm_p->msgarray[j].op_status;
            }
        }
    }
    return 0;
}

/* root_check_comp_fn()
 *
 * completion function for PVFS_SERV_PARAM_ROOT_CHECK parameter; it
 * handles this special case operation in which we want just one
 * server to return success and all others to return -PVFS_ENOENT.
 *
 * returns 0 if exactly one server claims ownership of root handle,
 * -PVFS_error on failure
 */
static int root_check_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i)
{
    int j = 0;
    int owners = 0;
    PINT_client_sm* sm_p = (PINT_client_sm*)v_p;

    /*
      store the op_status before it's overwritten with the return
      value of this comp_fn by the msgpairarray code
    */
    sm_p->u.setparam_list.root_check_status_array[i] =
        sm_p->msgarray[i].op_status;

    /* need to return non-zero status at the end if any of the statuses
     * are nonzero
     */
    if(i == (sm_p->u.setparam_list.count - 1))
    {
        for(; j < sm_p->u.setparam_list.count; ++j)
        {
            if(sm_p->u.setparam_list.root_check_status_array[j] == 0)
            {
                owners++;
            }
            else if(sm_p->u.setparam_list.root_check_status_array[j] != 
                    -PVFS_ENOENT)
            {
                return -PVFS_EDETAIL;
            }
        }

        if(owners != 1)
        {
            return -PVFS_EDETAIL;
        }
    }

    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
