/*
 *  fs/nfs/pnfs.h
 *
 *  pNFS client data structures.
 *
 *  Copyright (c) 2002 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Dean Hildebrand   <dhildebz@eecs.umich.edu>
 */

#ifndef FS_NFS_PNFS_H
#define FS_NFS_PNFS_H

void set_pnfs_layoutdriver(struct super_block *sb, u32 id);
void unmount_pnfs_layoutdriver(struct super_block *sb);
ssize_t pnfs_file_write(struct file* filp, const char __user *buf, size_t count, loff_t* pos);
ssize_t pnfs_file_read(struct file* filp, char __user *buf, size_t count, loff_t* pos);
int pnfs_use_read(struct inode *inode, ssize_t count);
int pnfs_use_write(struct inode *inode, ssize_t count);
int pnfs_writepages(struct nfs_write_data *wdata, int how);
int pnfs_readpages(struct nfs_read_data *rdata);
int pnfs_fsync(struct file *file, struct dentry *dentry, int datasync);
unsigned int pnfs_getboundary(struct inode* inode);
unsigned int pnfs_getpages(struct inode* inode, int iswrite);
int pnfs_initialize(void);
void pnfs_uninitialize(void);
void pnfs_layoutcommit_done(struct pnfs_layoutcommit_data *data, int status);
int pnfs_layoutcommit_inode(struct inode *inode, int sync);
void pnfs_update_last_write(struct nfs_inode* nfsi, loff_t offset, size_t extent);
void pnfs_need_layoutcommit(struct nfs_inode* nfsi, struct nfs_open_context *ctx);
int pnfs_enabled_sb(struct nfs_server* nfss);
int pnfs_use_nfsv4_wproto(struct inode *inode, ssize_t count);
int pnfs_use_nfsv4_rproto(struct inode *inode, ssize_t count);
unsigned int pnfs_getiosize(struct nfs_server *server);
int pnfs_commit(struct inode* inode, struct list_head *head, int sync, struct nfs_write_data *data);
unsigned int pnfs_getboundary(struct inode* inode);

#endif /* FS_NFS_PNFS_H */
