/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-storage.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "gossip.h"

/* Implementation notes
 *
 * This is a complicated machine.  It is capable of removing the three
 * externally visible PVFS2 object types: datafiles, metafiles, and
 * directories.
 *
 * For a datafile, the path through the state machine looks like:
 * 1) prelude
 * 2) check_object_type
 * 3) verify_object_metadata
 * 4) remove_dspace
 * 5) final_response
 * 6) cleanup
 *
 * For metafiles and symlinks, the path is:
 * 1) prelude
 * 2) check_object_type
 * 3) verify_object_metadata
 * 4) remove_dspace
 * 5) final_response
 * 6) cleanup
 *
 * For a directory that has (or at one time had) entries, the path is:
 * 1) prelude
 * 2) check_object_type
 * 3) verify_object_metadata
 * 4) try_to_read_dirdata_handle
 * 5) remove_dirdata_dspace
 * 6) remove_dspace
 * 7) final_response
 * 8) cleanup
 *
 * A directory that never had entries will skip step (5), as there
 * would be no dirdata dspace.
 */

enum
{
    STATE_TYPE_DIRECTORY = 1,
    STATE_TYPE_DATAFILE = 2
};

static int remove_check_object_type(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_verify_object_metadata(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_remove_dspace(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_read_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_getattr_of_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_check_dirdata_entries(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_remove_dirdata_dspace(
    PINT_server_op *s_op, job_status_s *js_p);
static int remove_setup_work(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_check_object_type[];
static union PINT_state_array_values ST_verify_object_metadata[];
static union PINT_state_array_values ST_remove_dspace[];
static union PINT_state_array_values ST_read_dirdata_handle[];
static union PINT_state_array_values ST_getattr_of_dirdata_handle[];
static union PINT_state_array_values ST_check_dirdata_entries[];
static union PINT_state_array_values ST_remove_dirdata_dspace[];

struct PINT_state_machine_s pvfs2_remove_work_sm =
{
	ST_check_object_type,
	"pvfs2_remove_work_sm"
};
static union PINT_state_array_values ST_check_object_type[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_check_object_type,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_object_metadata,
(union PINT_state_array_values) STATE_TYPE_DATAFILE,
(union PINT_state_array_values) ST_remove_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_verify_object_metadata[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_verify_object_metadata,
(union PINT_state_array_values) STATE_TYPE_DIRECTORY,
(union PINT_state_array_values) ST_read_dirdata_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_remove_dspace[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_remove_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_read_dirdata_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_read_dirdata_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_getattr_of_dirdata_handle,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_dspace
};

static union PINT_state_array_values ST_getattr_of_dirdata_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_getattr_of_dirdata_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_check_dirdata_entries,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_check_dirdata_entries[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_check_dirdata_entries,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_dirdata_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_remove_dirdata_dspace[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_remove_dirdata_dspace,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_setup_work[];
static union PINT_state_array_values ST_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_remove_sm =
{
	ST_prelude,
	"pvfs2_remove_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setup_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_setup_work[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_setup_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_work
};

static union PINT_state_array_values ST_work[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_remove_work_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) remove_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 181 "src/server/remove.sm"


/*
 * Function: remove_check_object_type
 *
 * decides whether to follow the path for datafile removal or
 * non-datafile removal, based on whether we were able to successfully
 * retrive object attributes earlier
 *
 */
static int remove_check_object_type(PINT_server_op *s_op,
                                    job_status_s *js_p)
{
    PINT_STATE_DEBUG("check_object_type");

    if(s_op->attr.mask == 0)
    {
	/* it must be a datafile, transition to try reading datafile 
	 * attribs with dspace_getattr()
	 */
	js_p->error_code = STATE_TYPE_DATAFILE;
	return(1);
    }

    js_p->error_code = 0;
    return(1);
}

/*
 * Function: remove_verify_object_metadata
 *
 * Verifies that the user has permission to access the file (not yet
 * implemented).  Also directs removal of dirdata dspace in the case
 * of a directory.
 *
 * This state has changed some over time; it might need a new name.
 *
 * Note: errors from the previous state are redirected elsewhere, so
 * we know that we have metadata if we make it here.
 */
static int remove_verify_object_metadata(PINT_server_op *s_op,
					 job_status_s *js_p)
{
    PVFS_object_attr *a_p;

    PINT_STATE_DEBUG("verify_object_metadata");

    a_p = &s_op->attr;

    js_p->error_code = 0;
    
    gossip_debug(GOSSIP_SERVER_DEBUG,
		 "  attrs read from keyval = (owner = %d, "
                 "group = %d, perms = %o, type = %d)\n",
		 a_p->owner,
		 a_p->group,
		 a_p->perms,
		 a_p->objtype);

    if (a_p->objtype == PVFS_TYPE_DIRECTORY)
    {
	js_p->error_code = STATE_TYPE_DIRECTORY;

	gossip_debug(
            GOSSIP_SERVER_DEBUG, "  type is directory; removing "
            "dirdata object before removing directory itself.\n");
    }
    return 1;
}

static int remove_read_dirdata_handle(PINT_server_op *s_op,
                                      job_status_s *js_p)
{
    int ret;
    job_id_t j_id;

    PINT_STATE_DEBUG("read_dirdata_handle");

    /* set up key and value structures for reading the dirdata handle */
    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    s_op->val.buffer = &s_op->u.remove.dirdata_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(GOSSIP_SERVER_DEBUG,
		 "  trying to read dirdata handle (coll_id = %d, "
                 "handle = %Lu, key = %s (%d), val_buf = %p (%d))\n",
		 s_op->u.remove.fs_id, Lu(s_op->u.remove.handle),
		 (char *)s_op->key.buffer, s_op->key.buffer_sz,
		 s_op->val.buffer, s_op->val.buffer_sz);

    ret = job_trove_keyval_read(
        s_op->u.remove.fs_id, s_op->u.remove.handle,
        &s_op->key, &s_op->val, 0, NULL, s_op, 0, js_p,
        &j_id, server_job_context);

    return ret;
}

static int remove_getattr_of_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret;
    job_id_t tmp_id;

    PINT_STATE_DEBUG("read_dirdata_handle");

    if (js_p->error_code)
    {
        return 1;
    }
    js_p->error_code = 0;

    gossip_debug(GOSSIP_SERVER_DEBUG, "  trying to getattr of "
                 "dirdata handle (coll_id = %d, handle = %Lu\n",
                 s_op->u.remove.fs_id, Lu(s_op->u.remove.handle));

    ret = job_trove_dspace_getattr(
        s_op->u.remove.fs_id, s_op->u.remove.dirdata_handle, s_op,
        &s_op->u.remove.dirdata_ds_attr, 0, js_p, &tmp_id,
        server_job_context);

    return ret;
}

static int remove_check_dirdata_entries(
    PINT_server_op *s_op, job_status_s *js_p)
{
    if (js_p->error_code == 0)
    {
        if (s_op->u.remove.dirdata_ds_attr.k_size > 0)
        {
            gossip_debug(GOSSIP_SERVER_DEBUG, " detected non-empty "
                         "directory -- returning error\n");
            js_p->error_code = -PVFS_ENOTEMPTY;
        }
    }
    return 1;
}

/*
 * Function: remove_remove_dirdata_dspace
 *
 * Remove the dirdata dspace using the handle that we ready in the
 * read_dirdata_handle state.
 */
static int remove_remove_dirdata_dspace(PINT_server_op *s_op,
					job_status_s *js_p)
{
    int ret;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("remove_dirdata_dspace");

    gossip_debug(GOSSIP_SERVER_DEBUG,
		 "  removing dirdata dspace %Lu\n",
		 Lu(s_op->u.remove.dirdata_handle));

    ret = job_trove_dspace_remove(
        s_op->u.remove.fs_id,
        s_op->u.remove.dirdata_handle,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.remove.fs_id),
        s_op,
        0,
        js_p,
        &j_id,
        server_job_context);

    return ret;
}

/*
 * Function: remove_remove_dspace
 *
 * Remove the dspace using the handle from the incoming request
 * (which was verified in previous states).
 */
static int remove_remove_dspace(PINT_server_op *s_op,
				job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("remove_dspace");

    gossip_debug(GOSSIP_SERVER_DEBUG, "(%p) remove: removing dspace "
                 "object %Lu,%d\n", s_op, Lu(s_op->u.remove.handle),
                 s_op->u.remove.fs_id);

    ret = job_trove_dspace_remove(
        s_op->u.remove.fs_id, s_op->u.remove.handle,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.remove.fs_id), s_op, 0, js_p,
        &j_id, server_job_context);

    return ret;
}


/*
 * Function: remove_cleanup
 *
 * Free all memory associated with this request and return 0, indicating
 * we're done processing.
 */
static int remove_cleanup(PINT_server_op *s_op,
			  job_status_s *js_p)
{
    PINT_STATE_DEBUG("cleanup");

    return(server_state_machine_complete(s_op));
}

static int remove_setup_work(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("setup_work");

    s_op->u.remove.handle = s_op->req->u.remove.handle;
    s_op->u.remove.fs_id = s_op->req->u.remove.fs_id;

    js_p->error_code = 0;
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
