/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <malloc.h>
#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "trove.h"

enum
{
    STATE_ENOTDIR = 7
};

static int readdir_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int readdir_read_dirdata_handle(
    PINT_server_op *s_op, job_status_s* js_p);
static int readdir_iterate_on_entries(
    PINT_server_op *s_op, job_status_s* js_p);
static int readdir_verify_directory_metadata(
    PINT_server_op *s_op, job_status_s* js_p);
static int readdir_setup_resp(
    PINT_server_op *s_op, job_status_s* js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_iterate_on_entries[];
static union PINT_state_array_values ST_read_dirdata_handle[];
static union PINT_state_array_values ST_verify_directory_metadata[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_readdir_sm =
{
	ST_prelude,
	"pvfs2_readdir_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_directory_metadata,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_verify_directory_metadata[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_verify_directory_metadata,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_dirdata_handle,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_dirdata_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_read_dirdata_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_iterate_on_entries,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_iterate_on_entries[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_iterate_on_entries,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) readdir_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 91 "src/server/readdir.sm"


static int readdir_verify_directory_metadata(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *attr = &s_op->attr;

    PINT_STATE_DEBUG("verify_directory_metadata");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_READDIR_DEBUG, " - attrs: owner=%d, group=%d, "
                 "perms=%d\n\ttype=%d, mtime=%Lu\n", attr->owner,
                 attr->group, attr->perms, attr->objtype,
                 Lu(attr->mtime));

    if (attr->objtype != PVFS_TYPE_DIRECTORY)
    {
	gossip_debug(GOSSIP_READDIR_DEBUG, "  object is not a directory; "
                     "halting readdir and sending response\n");

	js_p->error_code = STATE_ENOTDIR;
    }

    s_op->u.readdir.directory_version = (uint64_t)attr->mtime;
    return 1;
}

static int readdir_read_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    PINT_STATE_DEBUG("read_dirdata_handle");

    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    s_op->val.buffer = &s_op->u.readdir.dirent_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(
        GOSSIP_READDIR_DEBUG, " - reading metadata: [%Lu,%d], "
        "key=%s\n\t(sz=%d) val_buf=%p (sz=%d)\n",
        Lu(s_op->req->u.readdir.handle), s_op->req->u.readdir.fs_id,
        (char *)s_op->key.buffer, s_op->key.buffer_sz,
        s_op->val.buffer, s_op->val.buffer_sz);

    ret = job_trove_keyval_read(
        s_op->req->u.readdir.fs_id, s_op->req->u.readdir.handle,
        &s_op->key, &s_op->val, 0, NULL, s_op, 0, js_p, &i,
        server_job_context);

    return ret;
}

static int readdir_iterate_on_entries(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    int j = 0, memory_size = 0, kv_array_size = 0;
    char *memory_buffer = NULL;
    job_id_t j_id;

    PINT_STATE_DEBUG("iterate_on_entries");

    /*
      if a client issues a readdir but asks for no entries, we can
      skip doing anything here
    */
    if (s_op->req->u.readdir.dirent_count == 0)
    {
	js_p->error_code = 0;
        return 1;
    }

    if (s_op->req->u.readdir.dirent_count > PVFS_REQ_LIMIT_DIRENT_COUNT)
    {
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }

    /*
      calculate total memory needed:
      - 2 * dirent_count keyval structures to pass to iterate function
      - dirent_count dirent structures to hold the results
    */
    kv_array_size = (s_op->req->u.readdir.dirent_count *
                     sizeof(TROVE_keyval_s));

    memory_size = (2 * kv_array_size +
                   s_op->req->u.readdir.dirent_count *
                   sizeof(PVFS_dirent));

    memory_buffer = malloc(memory_size);
    if (!memory_buffer)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    /* set up all the pointers into the one big buffer */
    s_op->key_a = (TROVE_keyval_s *)memory_buffer;
    memory_buffer += kv_array_size;

    s_op->val_a = (TROVE_keyval_s *)memory_buffer;
    memory_buffer += kv_array_size;

    s_op->resp.u.readdir.dirent_array = (PVFS_dirent *)memory_buffer;

    for (j = 0; j < s_op->req->u.readdir.dirent_count; j++)
    {
	s_op->key_a[j].buffer =
            s_op->resp.u.readdir.dirent_array[j].d_name;
	s_op->key_a[j].buffer_sz = PVFS_NAME_MAX;
	s_op->val_a[j].buffer =
            &(s_op->resp.u.readdir.dirent_array[j].handle);
	s_op->val_a[j].buffer_sz = sizeof(PVFS_handle);
    }

    gossip_debug(
        GOSSIP_READDIR_DEBUG, " - iterating keyvals: [%Lu,%d], "
        "\n\ttoken=0x%x, count=%d\n",
        Lu(s_op->u.readdir.dirent_handle), s_op->req->u.readdir.fs_id,
        s_op->req->u.readdir.token, s_op->req->u.readdir.dirent_count);

    ret = job_trove_keyval_iterate(
        s_op->req->u.readdir.fs_id, s_op->u.readdir.dirent_handle,
        s_op->req->u.readdir.token, s_op->key_a, s_op->val_a,
        s_op->req->u.readdir.dirent_count, 0, NULL, s_op, 0, js_p, 
        &j_id, server_job_context);

    return ret;
}

static int readdir_setup_resp(
    PINT_server_op *s_op, job_status_s *js_p)
{

    PINT_STATE_DEBUG("setup_resp");

    if (js_p->error_code == STATE_ENOTDIR)
    {
	gossip_debug(GOSSIP_READDIR_DEBUG,
		     "  handle didn't refer to a directory\n");

	js_p->error_code = -PVFS_EINVAL;
	return 1;
    }
    else if (js_p->error_code != 0)
    {
	gossip_debug(GOSSIP_READDIR_DEBUG, "  error code = %d; "
                     "assuming empty directory\n", js_p->error_code);

	s_op->resp.u.readdir.dirent_count = 0;
	js_p->error_code = 0;
	return 1;
    }

    s_op->resp.u.readdir.directory_version =
        s_op->u.readdir.directory_version;
    s_op->resp.u.readdir.dirent_count = js_p->count;

    js_p->error_code = 0;
    return 1;
}

static int readdir_cleanup(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("cleanup");

    if (s_op->key_a)
    {
        free(s_op->key_a);
        s_op->key_a = NULL;
        s_op->val_a = NULL;
        s_op->resp.u.readdir.dirent_array = NULL;
    }
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
