/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */


#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "pvfs2-util.h"

static int mkdir_create(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_setattrib(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_create_dirdata_dspace(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_write_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_error(
    PINT_server_op *s_op, job_status_s *js_p);
static int mkdir_prep_sm(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_create[];
static union PINT_state_array_values ST_set_attrib[];
static union PINT_state_array_values ST_create_dirdata_dspace[];
static union PINT_state_array_values ST_write_dirdata_handle[];
static union PINT_state_array_values ST_err_msg[];

struct PINT_state_machine_s pvfs2_mkdir_work_sm =
{
	ST_create,
	"pvfs2_mkdir_work_sm"
};
static union PINT_state_array_values ST_create[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_create,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_set_attrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_err_msg
};

static union PINT_state_array_values ST_set_attrib[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_setattrib,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_create_dirdata_dspace,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_err_msg
};

static union PINT_state_array_values ST_create_dirdata_dspace[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_create_dirdata_dspace,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_write_dirdata_handle,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_err_msg
};

static union PINT_state_array_values ST_write_dirdata_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_write_dirdata_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) 2,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_err_msg
};

static union PINT_state_array_values ST_err_msg[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_error,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_prep_sm[];
static union PINT_state_array_values ST_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_mkdir_sm =
{
	ST_prelude,
	"pvfs2_mkdir_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_prep_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_prep_sm[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_prep_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_work
};

static union PINT_state_array_values ST_work[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_mkdir_work_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mkdir_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 112 "src/server/mkdir.sm"


/*
 * Function: mkdir_create
 *
 * Params:   server_op *s_op, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: 
 *
 * NOTE: returned handle will pop out in js_p->handle (the job status
 * struct).
 */
static int mkdir_create(PINT_server_op *s_op, job_status_s *js_p)
{

    int ret;
    job_id_t i;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("create");

    gossip_debug(GOSSIP_MKDIR_DEBUG, " creating dspace on coll_id %d\n",
                 s_op->u.mkdir.fs_id);

    gossip_debug(
        GOSSIP_MKDIR_DEBUG, " directory handle will "
        "be in starting hrange[0] %Lu-%Lu\n",
        Lu(s_op->u.mkdir.handle_extent_array.extent_array[0].first),
        Lu(s_op->u.mkdir.handle_extent_array.extent_array[0].last));

    ret = job_trove_dspace_create(
        s_op->u.mkdir.fs_id, &s_op->u.mkdir.handle_extent_array,
        PVFS_TYPE_DIRECTORY, NULL,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.mkdir.fs_id), s_op, 0, js_p, &i,
        server_job_context);

    return ret;
}

/*
 * Function: mkdir_setattrib
 *
 * Params:   server_op *s_op, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: 
 *           
 */
static int mkdir_setattrib(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t j_id;
    PVFS_ds_attributes *ds_attr = NULL;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("setattrib");

    /* save the handle from the mkdir in the response */
    s_op->resp.u.mkdir.handle = js_p->handle;

    gossip_debug(GOSSIP_MKDIR_DEBUG, " *** new directory has handle %Lu\n",
                 Lu(js_p->handle));

    ds_attr = (&s_op->ds_attr);

    gossip_debug(GOSSIP_MKDIR_DEBUG, " setting directory version to "
                 "%Lu\n\tmtime is %Lu\n", Lu(ds_attr->mtime),
                 Lu(PVFS_util_mkversion_time(ds_attr->mtime)));

    ret = job_trove_dspace_setattr(
        s_op->u.mkdir.fs_id, s_op->resp.u.mkdir.handle,
        ds_attr, PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.mkdir.fs_id),
        s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

static int mkdir_create_dirdata_dspace(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_ENOMEM;
    job_id_t i;
    PVFS_handle_extent_array extent_array;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("create_dirdata_dspace");

    gossip_debug(GOSSIP_MKDIR_DEBUG, " creating dspace on coll_id %d\n",
                 s_op->u.mkdir.fs_id);

    /* find our meta handle range for this create */
    ret = PINT_config_get_meta_handle_extent_array(
        user_opts, s_op->u.mkdir.fs_id, &extent_array);
    assert(ret == 0);
    assert(extent_array.extent_count > 0);

    gossip_debug(GOSSIP_MKDIR_DEBUG, " dirdata handle will "
                 "be in starting hrange[0] %Lu-%Lu\n",
                 Lu(extent_array.extent_array[0].first),
                 Lu(extent_array.extent_array[0].last));

    ret = job_trove_dspace_create(
        s_op->u.mkdir.fs_id, &extent_array, PVFS_TYPE_DIRDATA, NULL,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.mkdir.fs_id), s_op, 0, js_p, &i,
        server_job_context);

    free(extent_array.extent_array);
    extent_array.extent_array = NULL;

    return ret;
}

static int mkdir_write_dirdata_handle(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("write_dirdata_handle");

    if (js_p->error_code)
    {
        return 1;
    }
    js_p->error_code = 0;


    s_op->u.mkdir.dirent_handle = js_p->handle;

    gossip_debug(GOSSIP_MKDIR_DEBUG, " *** new dirdata has handle %Lu\n",
                 Lu(s_op->u.mkdir.dirent_handle));

    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    s_op->val.buffer = &s_op->u.mkdir.dirent_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(
        GOSSIP_MKDIR_DEBUG, "  writing dirdata handle (%Lu) "
        "into parent dir (%Lu)\n", Lu(s_op->u.mkdir.dirent_handle),
        Lu(s_op->resp.u.mkdir.handle));

    ret = job_trove_keyval_write(
        s_op->u.mkdir.fs_id, s_op->resp.u.mkdir.handle,
        &s_op->key, &s_op->val, PINT_config_get_trove_sync_meta(
            user_opts, s_op->u.mkdir.fs_id),
        NULL, s_op, 0, js_p, &i, server_job_context);

    return ret;
}

static int mkdir_error(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("error");
    s_op->resp.u.mkdir.handle = 0;

    if (js_p->error_code > -1)
    {
        js_p->error_code = -PVFS_EINVAL;
    }
    return 1;
}

/*
 * Function: mkdir_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int mkdir_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("cleanup");
    return(server_state_machine_complete(s_op));
}

static int mkdir_prep_sm(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *a_p = NULL;
    PVFS_ds_attributes *ds_attr = NULL;

    PINT_STATE_DEBUG("prep_sm");

    s_op->u.mkdir.fs_id = s_op->req->u.mkdir.fs_id;
    s_op->u.mkdir.handle_extent_array =
        s_op->req->u.mkdir.handle_extent_array;

    a_p = &(s_op->req->u.mkdir.attr);

    if (a_p->objtype != PVFS_TYPE_DIRECTORY)
    {
        js_p->error_code = -PVFS_EINVAL;
        return 1;
    }

    gossip_debug(GOSSIP_MKDIR_DEBUG, " attrs to write: [owner = %d, "
                 "group = %d, perms = %o]\n", a_p->owner, a_p->group,
                 a_p->perms);

    /* translate attrs to storage attr format */
    ds_attr = (&s_op->ds_attr);
    PVFS_object_attr_to_ds_attr(a_p, ds_attr);

    js_p->error_code = 0;
    return 1;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
