/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "server-config.h"
#include "pvfs2-server.h"

/*
 * if given a metafile, do a keyval flush
 * if given a datafile, do a bstream flush
 */
enum
{
    FLUSH_KEYVAL  = 4,
    FLUSH_BSTREAM = 5
};

static int flush_check_type(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_keyval_flush(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_bstream_flush(
    PINT_server_op *s_op, job_status_s * js_p);
static int flush_cleanup(
    PINT_server_op *s_op, job_status_s *ret);
static int flush_check_error(
    PINT_server_op *s_op, job_status_s *js_p);
void flush_init_state_machine(void);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_flush_check_type[];
static union PINT_state_array_values ST_kflush[];
static union PINT_state_array_values ST_kflush_check_error[];
static union PINT_state_array_values ST_bflush[];
static union PINT_state_array_values ST_bflush_check_error[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_flush_sm =
{
	ST_prelude,
	"pvfs2_flush_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_flush_check_type,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_flush_check_type[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_check_type,
(union PINT_state_array_values) FLUSH_KEYVAL,
(union PINT_state_array_values) ST_kflush,
(union PINT_state_array_values) FLUSH_BSTREAM,
(union PINT_state_array_values) ST_bflush,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_kflush[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_keyval_flush,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_kflush_check_error
};

static union PINT_state_array_values ST_kflush_check_error[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_check_error,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_bflush[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_bstream_flush,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_bflush_check_error
};

static union PINT_state_array_values ST_bflush_check_error[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_check_error,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) flush_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 103 "src/server/flush.sm"


static int flush_check_type(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("flush_check_type");

    js_p->error_code = 0;

    if (s_op->attr.objtype == PVFS_TYPE_METAFILE)
    {
        js_p->error_code = FLUSH_KEYVAL;
    }
    else if (s_op->attr.objtype == PVFS_TYPE_DATAFILE)
    {
        js_p->error_code = FLUSH_BSTREAM;
    }
    return 1;
}

/*
 * Function: flush_keyval_flush
 *
 * Params:  server_op *s_op,
 *	    job_status_s *js_p
 *
 * Pre: None
 * Post: None
 * Returns: int
 *
 * Synopsys: send a keyval flush request to storage
 *
 */
static int flush_keyval_flush(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t tmp_id;

    PINT_STATE_DEBUG("kflush");

    gossip_debug(GOSSIP_SERVER_DEBUG, " doing keyval flush on %Lu,%d\n",
                 Lu(s_op->req->u.flush.handle), s_op->req->u.flush.fs_id);

    ret = job_trove_keyval_flush(
        s_op->req->u.flush.fs_id,
        s_op->req->u.flush.handle,
        s_op->req->u.flush.flags,
        s_op,
        0,
        js_p,
        &tmp_id,
        server_job_context);

    return ret;
}

static int flush_check_error(PINT_server_op *s_op, job_status_s *js_p)
{
    char buf[64] = {0};
    PINT_STATE_DEBUG("{k,b}check_error");

    if (js_p->error_code != 0)
    {
        PVFS_strerror_r(js_p->error_code, buf, 64);

        gossip_err("failed to flush handle %Lu: %s\n",
                   Lu(s_op->req->u.flush.handle), buf);
    }
    return 1;
}

/*
 * Function: flush_bstream_flush
 *
 * Params:  server_op *s_op,
 *	    job_status_s *js_p
 *
 * Pre: None
 * Post: None
 * Returns: int
 *
 * Synopsys: send a bstream flush request to storage
 *
 */
static int flush_bstream_flush(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t i;

    PINT_STATE_DEBUG("bflush");

    gossip_debug(GOSSIP_SERVER_DEBUG, " doing bstream flush on %Lu,%d\n",
                 Lu(s_op->req->u.flush.handle), s_op->req->u.flush.fs_id);

    ret = job_trove_bstream_flush(
        s_op->req->u.flush.fs_id,
        s_op->req->u.flush.handle,
        s_op->req->u.flush.flags,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}
	    
static int flush_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("cleanup");

    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
