/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */


#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"

/* final-response state machine:
 * This is used as a nested state machine to perform two primary tasks:
 * - release the operation from the request scheduler
 * - send a response to the client
 */

/* PRECONDITIONS:
 * - the s_op->resp struct must be filled in with the response that
 *   needs to be sent (not yet encoded), with one exception:
 * - js_p->error_code must indicate the status value that you wish 
 *   to have set in the response structure
 * - if the operation has been scheduled, then the scheduled id must be
 *   stored in s_op->scheduled_id
 */

static int final_response_release(
    PINT_server_op *s_op, job_status_s *js_p);
static int final_response_send_resp(
    PINT_server_op *s_op, job_status_s *js_p);
static int final_response_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);

static void PINT_gossip_err_server_resp(
    struct PVFS_server_resp *resp);

static union PINT_state_array_values ST_release[];
static union PINT_state_array_values ST_send_resp[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_final_response_sm =
{
	ST_release,
	"pvfs2_final_response_sm"
};
static union PINT_state_array_values ST_release[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) final_response_release,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_send_resp
};

static union PINT_state_array_values ST_send_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) final_response_send_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) final_response_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 2
};

# 66 "src/server/final-response.sm"


/* final_response_release()
 *
 * releases the operation from the request scheduler
 */
static int final_response_release(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t tmp_id;

    gossip_debug(GOSSIP_SERVER_DEBUG, 
                 "(%p) %s (FR sm) state: release: (error_code = %d)\n", s_op,
                 PINT_map_server_op_to_string(s_op->req->op),
                 js_p->error_code);

    /* this seems a little odd, but since this is the first state of the
     * nested machine, now is the time to grab the error code if we
     * are going to use it
     */
    /* NOTE: we filter out any subsystem mask and make sure that this
     * shows up as a generic pvfs error on the client side
     */
    s_op->resp.status = -PVFS_ERROR_CODE(-js_p->error_code);

    /* catch cases in which the operation has not been scheduled */
    if (!s_op->scheduled_id)
    {
        js_p->error_code = 0;
        return 1;
    }

    ret = job_req_sched_release(
        s_op->scheduled_id, s_op, 0, js_p, &tmp_id, server_job_context);

    return ret;
}

/* final_response_send_resp()
 *
 * encodes and sends a response to the client
 */
static int final_response_send_resp(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t tmp_id;
    struct server_configuration_s *user_opts = get_server_config_struct();
    
    gossip_debug(
        GOSSIP_SERVER_DEBUG, 
	"(%p) %s (FR sm) state: send_resp (status = %d)\n",
	s_op,
	PINT_map_server_op_to_string(s_op->req->op),
	s_op->resp.status);

    if (js_p->error_code != 0)
    {
        gossip_lerr("Error: req_sched_release() failure; continuing...\n");
    }

    ret = PINT_encode(&s_op->resp, PINT_ENCODE_RESP, &(s_op->encoded),
                      s_op->addr, s_op->decoded.enc_type);
    if (ret < 0)
    {
        gossip_lerr("Error: PINT_encode() failure.\n");
        PINT_gossip_err_server_resp(&s_op->resp);

        js_p->error_code = ret;
        return 1;
    }

    /* send the response */
    ret = job_bmi_send_list(
        s_op->addr, s_op->encoded.buffer_list, s_op->encoded.size_list,
        s_op->encoded.list_count, s_op->encoded.total_size, s_op->tag,
        s_op->encoded.buffer_type, 0, s_op, 0, js_p, &tmp_id,
        server_job_context, user_opts->server_job_bmi_timeout);

    return ret;
}


/* final_response_cleanup()
 *
 * cleans up resources allocated while in this nested machine.  Right now 
 * that just means releasing the encoding of the response
 */
static int final_response_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    char status_string[64] = {0};

    gossip_debug(GOSSIP_SERVER_DEBUG, 
                 "(%p) %s (FR sm) state: cleanup\n",
                 s_op, PINT_map_server_op_to_string(s_op->req->op));

    PVFS_strerror_r(s_op->resp.status, status_string, 64);
    PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "finish (%s)\n", status_string);

    PINT_encode_release(&s_op->encoded, PINT_ENCODE_RESP);

    /* decrement reference count for this bmi address */
    BMI_set_info(s_op->addr, BMI_DEC_ADDR_REF, NULL);

    js_p->error_code = 0;
    return 1;
}

static __req_resp_type_desc_t s_req_resp_type_map[
    PVFS_MAX_SERVER_OP + 1] =
{
    { PVFS_SERV_INVALID, "PVFS_SERV_INVALID"},
    { PVFS_SERV_CREATE, "PVFS_SERV_CREATE" },
    { PVFS_SERV_REMOVE, "PVFS_SERV_REMOVE" },
    { PVFS_SERV_IO, "PVFS_SERV_IO" },
    { PVFS_SERV_GETATTR, "PVFS_SERV_GETATTR" },
    { PVFS_SERV_SETATTR, "PVFS_SERV_SETATTR" },
    { PVFS_SERV_LOOKUP_PATH, "PVFS_SERV_LOOKUP_PATH" },
    { PVFS_SERV_CRDIRENT, "PVFS_SERV_CRDIRENT" },
    { PVFS_SERV_RMDIRENT, "PVFS_SERV_RMDIRENT" },
    { PVFS_SERV_CHDIRENT, "PVFS_SERV_CHDIRENT" },
    { PVFS_SERV_TRUNCATE, "PVFS_SERV_TRUNCATE" },
    { PVFS_SERV_MKDIR, "PVFS_SERV_MKDIR" },
    { PVFS_SERV_READDIR, "PVFS_SERV_READDIR" },
    { PVFS_SERV_GETCONFIG, "PVFS_SERV_GETCONFIG" },
    { PVFS_SERV_WRITE_COMPLETION, "PVFS_SERV_WRITE_COMPLETION" },
    { PVFS_SERV_FLUSH, "PVFS_SERV_FLUSH" },
    { PVFS_SERV_MGMT_SETPARAM, "PVFS_SERV_MGMT_SETPARAM" },
    { PVFS_SERV_MGMT_NOOP, "PVFS_SERV_MGMT_NOOP" },
    { PVFS_SERV_STATFS, "PVFS_SERV_STATFS" },
    { PVFS_SERV_PERF_UPDATE, "PVFS_SERV_PERF_UPDATE" },
    { PVFS_SERV_MGMT_PERF_MON, "PVFS_SERV_MGMT_PERF_MON" },
    { PVFS_SERV_MGMT_ITERATE_HANDLES, "PVFS_SERV_MGMT_ITERATE_HANDLES" },
    { PVFS_SERV_MGMT_DSPACE_INFO_LIST,
      "PVFS_SERV_MGMT_DSPACE_INFO_LIST" },
    { PVFS_SERV_MGMT_EVENT_MON, "PVFS_SERV_MGMT_EVENT_MON" },
    { PVFS_SERV_MGMT_REMOVE_OBJECT, "PVFS_SERV_MGMT_REMOVE_OBJECT" },
    { PVFS_SERV_MGMT_REMOVE_DIRENT, "PVFS_SERV_MGMT_REMOVE_DIRENT" },
    { PVFS_SERV_MGMT_GET_DIRDATA_HANDLE,
      "PVFS_SERV_MGMT_GET_DIRDATA_HANDLE" },
    { PVFS_SERV_JOB_TIMER, "PVFS_SERV_JOB_TIMER" },
    { PVFS_SERV_PROTO_ERROR, "PVFS_SERV_PROTO_ERROR" },
    { PVFS_SERV_GETEATTR, "PVFS_SERV_GETEATTR" },
    { PVFS_SERV_SETEATTR, "PVFS_SERV_SETEATTR" },
    { PVFS_SERV_DELEATTR, "PVFS_SERV_DELEATTR" },
};

static void PINT_gossip_err_server_resp(
    struct PVFS_server_resp *resp)
{
    if (resp)
    {
        if (((int)resp->op > -1) && ((int)resp->op < PVFS_MAX_SERVER_OP))
        {
            gossip_err("Server Response %p is of type: %s\n",
                       resp, s_req_resp_type_map[resp->op].type_str);
        }
        else
        {
            gossip_err("Server Response %p is of type: UNKNOWN (op %d)\n",
                       resp, resp->op);
        }

        switch(resp->op)
        {
            case PVFS_SERV_GETATTR:
            {
                PVFS_object_attr *attr = &resp->u.getattr.attr;
                switch(attr->objtype)
                {
                    case PVFS_TYPE_METAFILE:
                    {
                        int i = 0;
                        gossip_err(
                            "METAFILE [ dist is %p, dist_size is %d,\n\t"
                            "   dfile_array is %p, dfile_count is %d ]\n",
                            attr->u.meta.dist, attr->u.meta.dist_size,
                            attr->u.meta.dfile_array, 
                            attr->u.meta.dfile_count);

                        if (attr->u.meta.dfile_array)
                        {
                            for(i = 0; i < attr->u.meta.dfile_count; i++)
                            {
                                gossip_err("   DATA HANDLE[%d] is %Lu\n", i,
                                           Lu(attr->u.meta.dfile_array[i]));
                            }
                        }
                    }
                    break;
                    case PVFS_TYPE_DATAFILE:
                        gossip_err("DATAFILE [ size is %Ld ]\n",
                                   Ld(attr->u.data.size));
                        break;
                    case PVFS_TYPE_SYMLINK:
                        gossip_err(
                            "SYMLINK [ target is %s ; len is %d ]\n",
                            attr->u.sym.target_path,
                            attr->u.sym.target_path_len);
                        break;
                    case PVFS_TYPE_DIRECTORY:
                        gossip_err("DIRECTORY [ n/a ]\n");
                        break;
                    case PVFS_TYPE_DIRDATA:
                        gossip_err("DIRDATA [ n/a ]\n");
                        break;
                    case PVFS_TYPE_NONE:
                        gossip_err("NONE [ n/a ]\n");
                        break;
                }
            }
            break;
            default:
                gossip_err("FIXME: unimplemented resp type to print\n");
                break;
        }
    }
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
