/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "gossip.h"

static int create_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int create_create(
    PINT_server_op *s_op, job_status_s* js_p);
static int create_setup_resp(
    PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_create[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_create_sm =
{
	ST_prelude,
	"pvfs2_create_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_create,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_create[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_create,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) create_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 63 "src/server/create.sm"


/*
 * Function: create_create
 *
 * Params:   server_op *s_op, 
 *           job_status_s* js_p
 *
 * Pre:      None
 *
 * Post:     None
 *
 * Returns:  int
 *
 * Synopsis: Create the new dataspace with the values provided in the response.
 *           
 */
static int create_create(PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -1;
    job_id_t i;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("create");

    ret = job_trove_dspace_create(
        s_op->req->u.create.fs_id,
        &s_op->req->u.create.handle_extent_array,
        s_op->req->u.create.object_type,
        NULL,
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.create.fs_id),
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return(ret);
}

/* create_setup_resp()
 *
 * fills in the response structure based on results of previous operation
 */
static int create_setup_resp(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("setup_resp");

    if (js_p->error_code == 0)
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "Handle created: %Lu\n",
                     Lu(js_p->handle));
	s_op->resp.u.create.handle = js_p->handle;
        switch(s_op->req->u.create.object_type)
        {
            case PVFS_TYPE_NONE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %Lu, type unknown.\n");
                break;
            case PVFS_TYPE_METAFILE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %Lu, type metafile.\n");
                break;
            case PVFS_TYPE_DATAFILE:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %Lu, type datafile.\n");
                break;
            case PVFS_TYPE_DIRECTORY:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, 
                    "new handle: %Lu, type directory.\n");
                break;
            case PVFS_TYPE_SYMLINK:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %Lu, type symlink.\n");
                break;
            case PVFS_TYPE_DIRDATA:
                PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG,    
                    "new handle: %Lu, type dirdata.\n");
                break;
        }
    }

    /* NOTE: we _deliberately_ leave the error_code unchanged so that it
     * can be used by the next state.
     */
    return(1);
}


/*
 * Function: create_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s* js_p
 *
 * Pre:      None
 *
 * Post:     None
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int create_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");

    return(server_state_machine_complete(s_op));
}


/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
