/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>
#include <unistd.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "pvfs2-util.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

static int server_parse_config(
    struct server_configuration_s *config,
    char *fs_config_buf,
    uint32_t fs_config_buf_size,
    char *server_config_buf,
    uint32_t server_config_buf_size);

/* state function prototypes */
static int server_get_config_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int server_get_config_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int server_get_config_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int server_get_config_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_server_get_config_sm =
{
	ST_setup_msgpair,
	"pvfs2_server_get_config_sm"
};
static union PINT_state_array_values ST_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) server_get_config_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) server_get_config_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 67 "src/client/sysint/server-get-config.sm"


/*
  given mount information, retrieve the server's configuration by
  issuing a getconfig operation.  on successful response, we parse the
  configuration and fill in the config object specified.

  returns 0 on success, -errno on error
*/
int PINT_server_get_config(
    struct server_configuration_s *config,
    struct PVFS_sys_mntent* mntent_p)
{
    int ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;
    PVFS_error error = 0;
    PVFS_credentials creds;
    struct filesystem_configuration_s* cur_fs = NULL;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PINT_server_get_config entered\n");

    if (!config || !mntent_p)
    {
	return ret;
    }

    PVFS_util_gen_credentials(&creds);

    gossip_debug(GOSSIP_CLIENT_DEBUG, "asked for fs name = %s\n",
                 mntent_p->pvfs_fs_name);

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    /* NOTE: we set these fields manually here rather than use
     * PINT_init_msgarray_params(), because we don't yet have a server
     * configuration file to override default parameters.
     */
    sm_p->msgarray_params.job_context = pint_client_sm_context;
    sm_p->msgarray_params.job_timeout = 30;   /* 30 second job timeout */
    sm_p->msgarray_params.retry_delay = 2000; /* 2 second retry delay */
    sm_p->msgarray_params.retry_limit = 5;    /* retry up to 5 times */
    PINT_init_sysint_credentials(sm_p->cred_p, &creds);
    sm_p->u.get_config.mntent = mntent_p;

    if (ENCODING_IS_VALID(mntent_p->encoding))
    {
        sm_p->msgpair.enc_type = mntent_p->encoding;
    }

    sm_p->msgarray_count = 1;
    sm_p->msgarray = &(sm_p->msgpair);

    ret = PINT_client_state_machine_post(
        sm_p, PVFS_SERVER_GET_CONFIG, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PINT_client_state_machine_post call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "X-get_config", &error);
        if (ret)
        {
            PVFS_perror_gossip("PINT_sys_wait call", ret);
            error = ret;
        }
    }

    if (error)
    {
	goto exit_path;
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PINT_server_get_config completed\n");

    ret = server_parse_config(
        config,  sm_p->u.get_config.fs_config_buf,
        sm_p->u.get_config.fs_config_buf_size,
        sm_p->u.get_config.server_config_buf,
        sm_p->u.get_config.server_config_buf_size);

    if (ret)
    {
	gossip_err("Failed to get_config from host %s\n",
                   mntent_p->the_pvfs_config_server); 
	error = -PVFS_ENODEV;
        goto exit_path;
    }

    cur_fs = PINT_config_find_fs_name(config, mntent_p->pvfs_fs_name);
    if (!cur_fs)
    {
	gossip_err("Warning:\n Cannot retrieve information about "
		"pvfstab entry %s\n",
		mntent_p->the_pvfs_config_server);

	/*
          if the device has no space left on it, we can't save
          the config file for parsing and get a failure; make
          a note of that possibility here
        */ 
	gossip_err("\nHINTS: If you're sure that your pvfstab file "
                   "contains valid information,\n please make sure "
                   "that you are not out of disk space and that you "
                   "have\n write permissions in the current "
                   "directory or in the /tmp directory\n\n");

	error = -PVFS_ENODEV;
        goto exit_path;
    }

    mntent_p->fs_id = cur_fs->coll_id;
    cur_fs->flowproto = mntent_p->flowproto;
    cur_fs->encoding = mntent_p->encoding;

  exit_path:

    if (sm_p && !sm_p->u.get_config.persist_config_buffers)
    {
	free(sm_p->u.get_config.fs_config_buf);
	free(sm_p->u.get_config.server_config_buf);

        sm_p->u.get_config.fs_config_buf = NULL;
        sm_p->u.get_config.server_config_buf = NULL;
    }

    PINT_sys_release(op_id);
    return error;
}

static int server_parse_config(
    struct server_configuration_s *config,
    char *fs_config_buf,
    uint32_t fs_config_buf_size,
    char *server_config_buf,
    uint32_t server_config_buf_size)
{
    int ret = 1, template_index = 1;
    int fs_fd = 0, server_fd = 0;
    char fs_template_array[2][64] =
    {
        ".__pvfs_fs_configXXXXXX",
        "/tmp/.__pvfs_fs_configXXXXXX"
    };
    char server_template_array[2][64] =
    {
        ".__pvfs_server_configXXXXXX",
        "/tmp/.__pvfs_server_configXXXXXX"
    };
    char *fs_template = NULL;
    char *server_template = NULL;

    if (config)
    {
        assert(fs_config_buf);
        assert(server_config_buf);

        while(1)
        {
            assert(template_index > -1);
            fs_template = fs_template_array[template_index];
            server_template = server_template_array[template_index];

            fs_fd = mkstemp(fs_template);
            if (fs_fd != -1)
            {
                break;
            }
            else if ((--template_index) < 0)
            {
                gossip_err("Error: Cannot create temporary "
                           "configuration files!\n");
                return ret;
            }
        }

        server_fd = mkstemp(server_template);
        if (server_fd == -1)
        {
            close(fs_fd);
            remove(fs_template);
            gossip_err("mkstemp(%s) failed\n", server_template);
            return ret;
        }

        assert(!fs_config_buf[fs_config_buf_size - 1]);
        assert(!server_config_buf[server_config_buf_size - 1]);

        if (write(fs_fd,fs_config_buf, 
		    (fs_config_buf_size - 1)) == (fs_config_buf_size - 1))
        {
            if (write(server_fd,server_config_buf,
                      (server_config_buf_size - 1)) ==
                (server_config_buf_size - 1))
            {
                ret = PINT_parse_config(
                    config, fs_template, server_template);
            }
        }
        close(fs_fd);
        close(server_fd);

        remove(fs_template);
        remove(server_template);
    }
    return ret;
}

static int server_get_config_setup_msgpair(PINT_client_sm *sm_p,
                                           job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;
    PVFS_BMI_addr_t serv_addr;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
		"get_config state: server_get_config_setup_msgpair\n");

    msg_p = &sm_p->msgarray[0];

    ret = BMI_addr_lookup(&serv_addr,
	    sm_p->u.get_config.mntent->the_pvfs_config_server);
    if (ret < 0)
    {
        gossip_lerr("Failed to resolve BMI address %s\n",
                    sm_p->u.get_config.mntent->the_pvfs_config_server);
        return ret;
    }

    PINT_SERVREQ_GETCONFIG_FILL(msg_p->req, *sm_p->cred_p);

    msg_p->fs_id = PVFS_FS_ID_NULL;
    msg_p->handle = PVFS_HANDLE_NULL;
    msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
    msg_p->comp_fn = server_get_config_comp_fn;
    msg_p->svr_addr = serv_addr;

    js_p->error_code = 0;
    return 1;
}

static int server_get_config_cleanup(PINT_client_sm *sm_p,
                                    job_status_s *js_p)
{
    sm_p->error_code  = js_p->error_code;
    sm_p->op_complete = 1;

    return 0;
}

static int server_get_config_comp_fn(
    void *v_p,
    struct PVFS_server_resp *resp_p,
    int i)
{
    int j = 0;
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;

    /* only posted one msgpair */
    assert(i==0);

    /* if this particular request was successful, then store the server
     * response and let the caller sort it out */

    if (sm_p->msgarray[i].op_status == 0)
    {
	sm_p->u.get_config.fs_config_buf = 
		strdup(resp_p->u.getconfig.fs_config_buf);
	sm_p->u.get_config.fs_config_buf_size = 
		resp_p->u.getconfig.fs_config_buf_size;
	sm_p->u.get_config.server_config_buf = 
		strdup(resp_p->u.getconfig.server_config_buf);
	sm_p->u.get_config.server_config_buf_size = 
		resp_p->u.getconfig.server_config_buf_size;
    }

    /* if this is the last response, check all of the status values
     * and return error code if any requests failed
     */
    if (i == (sm_p->msgarray_count -1))
    {
	for (j=0; j < sm_p->msgarray_count; j++)
	{
	    if (sm_p->msgarray[j].op_status != 0)
	    {
		return(sm_p->msgarray[j].op_status);
	    }
	}
    }
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
