/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for removing specific objects.
 *  These are used primarily for file system repair purposes (to remove
 *  orphaned objects), although they can also be used to create specific
 *  inconsistency cases for testing of failure tolerance.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

static int mgmt_remove_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_remove_object_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_remove_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int mgmt_remove_object_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_remove_object_setup_msgpair[];
static union PINT_state_array_values ST_remove_object_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_remove_object_sm =
{
	ST_init,
	"pvfs2_client_mgmt_remove_object_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_remove_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_object_setup_msgpair
};

static union PINT_state_array_values ST_remove_object_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_remove_object_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_object_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_remove_object_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_remove_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 74 "src/client/sysint/mgmt-remove-object.sm"


/** Initiate removal of a specific file system object.
 */
PVFS_error PVFS_imgmt_remove_object(
    PVFS_object_ref object_ref, 
    PVFS_credentials *credentials,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_remove_object entered\n");

    if ((object_ref.handle == PVFS_HANDLE_NULL) ||
        (object_ref.fs_id == PVFS_FS_ID_NULL))
    {
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, object_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->object_ref = object_ref;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Trying to remove handle %Lu,%d\n",
        Lu(object_ref.handle), object_ref.fs_id);

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_imgmt_remove_object calling "
                 "PINT_client_state_machine_post()\n");

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_REMOVE_OBJECT, op_id, user_ptr);
}

/** Remove a specific file system object.
 */
PVFS_error PVFS_mgmt_remove_object(
    PVFS_object_ref object_ref, 
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_remove_object entered\n");

    ret = PVFS_imgmt_remove_object(object_ref, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_remove_object call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_mgmt_wait(op_id, "remove_object", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    PINT_mgmt_release(op_id);
    return error;
}

/****************************************************************/

static int mgmt_remove_init(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mgmt_remove_init called\n");

    assert(js_p->error_code == 0);
    return 1;
}

static int mgmt_remove_object_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_MGMT_REMOVE_OBJECT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->object_ref.handle);

    gossip_debug(GOSSIP_REMOVE_DEBUG, "- doing MGMT_REMOVE_OBJECT on "
                 "%Lu,%d\n", Lu(sm_p->object_ref.handle),
                 sm_p->object_ref.fs_id);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mgmt_remove_object_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map server address\n");
	js_p->error_code = ret;
    }
    return 1;
}

static int mgmt_remove_object_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;

    assert(resp_p->op == PVFS_SERV_MGMT_REMOVE_OBJECT);

    if (resp_p->status == 0)
    {
        gossip_debug(
            GOSSIP_CLIENT_DEBUG,
            "  mgmt_remove_object_comp_fn: object %Lu,%d removed\n",
            Lu(sm_p->object_ref.handle), sm_p->object_ref.fs_id);
    }
    return resp_p->status;
}

static int mgmt_remove_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mgmt_remove_cleanup called\n");

    sm_p->error_code = js_p->error_code;

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
