/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for obtaining datafile handles
 *  for a given file.
 *
 *  This are used primarily for file system check and repair purposes.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"

extern job_context_id pint_client_sm_context;

static int mgmt_get_dfile_array_cleanup(
    PINT_client_sm * sm_p, job_status_s * js_p);

static union PINT_state_array_values ST_getattr[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_get_dfile_array_sm =
{
	ST_getattr,
	"pvfs2_client_mgmt_get_dfile_array_sm"
};
static union PINT_state_array_values ST_getattr[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_get_dfile_array_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 53 "src/client/sysint/mgmt-get-dfile-array.sm"


/** Initiate retrieval of list of handles of datafiles associated with
 *  a given file.
 */
PVFS_error PVFS_imgmt_get_dfile_array(
    PVFS_object_ref ref,
    PVFS_credentials *credentials,
    PVFS_handle *dfile_array,
    int dfile_count,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_get_dfile_array entered\n");

    if (!dfile_array)
    {
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (!sm_p)
    {
	return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->object_ref = ref;
    sm_p->u.get_dfile_array.dfile_array = dfile_array;
    sm_p->u.get_dfile_array.dfile_count = dfile_count;

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        ref,
        PVFS_ATTR_META_ALL|PVFS_ATTR_COMMON_TYPE,
        PVFS_TYPE_METAFILE);

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_GET_DFILE_ARRAY, op_id, user_ptr);
}

/** Obtain the list of handles of datafiles associated with a given file.
 */
PVFS_error PVFS_mgmt_get_dfile_array(
    PVFS_object_ref ref,
    PVFS_credentials *credentials,
    PVFS_handle *dfile_array,
    int dfile_count)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_get_dfile_array entered\n");

    ret = PVFS_imgmt_get_dfile_array(
        ref, credentials, dfile_array, dfile_count, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_get_dfile_array call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_mgmt_wait(op_id, "get_dfile_array", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    PINT_mgmt_release(op_id);
    return error;
}


/****************************************************************/

static int mgmt_get_dfile_array_cleanup(
    PINT_client_sm * sm_p,
    job_status_s * js_p)
{
    PVFS_object_attr *attr = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
        "mgmt_get_dfile_array state: cleanup\n");

    sm_p->error_code = js_p->error_code;

    if (sm_p->error_code == 0)
    {
        attr = &sm_p->getattr.attr;
        assert(attr);
        assert(attr->mask & PVFS_ATTR_META_DFILES);
        assert(attr->u.meta.dfile_count > 0);

        /* copy out going parameters */
        sm_p->u.get_dfile_array.dfile_count =
            attr->u.meta.dfile_count;
        memcpy(sm_p->u.get_dfile_array.dfile_array,
               attr->u.meta.dfile_array,
               (attr->u.meta.dfile_count * sizeof(PVFS_handle)));
    }

    PINT_SM_GETATTR_STATE_CLEAR(sm_p->getattr);

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
