/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for event monitoring.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pvfs2-mgmt.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

static int mgmt_event_mon_list_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_event_mon_list_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

/* completion function prototypes */
static int event_mon_list_comp_fn(
    void* v_p, struct PVFS_server_resp* resp_p, int i);

static union PINT_state_array_values ST_setup_msgpair[];
static union PINT_state_array_values ST_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_event_mon_list_sm =
{
	ST_setup_msgpair,
	"pvfs2_client_mgmt_event_mon_list_sm"
};
static union PINT_state_array_values ST_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_event_mon_list_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_event_mon_list_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 64 "src/client/sysint/mgmt-event-mon-list.sm"


PVFS_error PVFS_imgmt_event_mon_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    struct PVFS_mgmt_event** event_matrix,
    PVFS_BMI_addr_t *addr_array,
    int server_count,
    int event_count,
    PVFS_error_details *details,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_event_mon_list entered\n");

    if ((server_count < 1) || (event_count < 1) ||
        !event_matrix || !addr_array)
    {
        return -PVFS_EINVAL;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (!sm_p)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.event_mon_list.fs_id = fs_id;
    sm_p->u.event_mon_list.event_matrix = event_matrix;
    sm_p->u.event_mon_list.server_count = server_count;
    sm_p->u.event_mon_list.event_count = event_count;
    sm_p->u.event_mon_list.addr_array = addr_array;
    sm_p->u.event_mon_list.details = details;

    sm_p->msgarray_count = server_count;
    sm_p->msgarray = (PINT_sm_msgpair_state *)malloc(
        server_count * sizeof(PINT_sm_msgpair_state));
    if (sm_p->msgarray == NULL)
    {
        free(sm_p);
        return -PVFS_ENOMEM;
    }

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_EVENT_MON_LIST, op_id, user_ptr);
}

PVFS_error PVFS_mgmt_event_mon_list(
    PVFS_fs_id fs_id,
    PVFS_credentials *credentials,
    struct PVFS_mgmt_event** event_matrix,
    PVFS_BMI_addr_t *addr_array,
    int server_count,
    int event_count,
    PVFS_error_details *details)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_event_mon_list entered\n");

    ret = PVFS_imgmt_event_mon_list(
        fs_id, credentials, event_matrix, addr_array, server_count,
        event_count, details, &op_id, NULL);

    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_event_mon_list call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_mgmt_wait(op_id, "event_mon_list", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_event_mon_list completed\n");

    PINT_mgmt_release(op_id);
    return error;
}

static int mgmt_event_mon_list_setup_msgpair(PINT_client_sm *sm_p,
                                             job_status_s *js_p)
{
    int i = 0;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "event_mon_list state: "
                 "mgmt_event_mon_list_setup_msgpair\n");

    js_p->error_code = 0;

    for (i = 0; i < sm_p->msgarray_count; i++)
    {
        msg_p = &sm_p->msgarray[i];

        PINT_SERVREQ_MGMT_EVENT_MON_FILL(
            msg_p->req,
            *sm_p->cred_p,
            sm_p->u.event_mon_list.event_count);

        msg_p->fs_id = sm_p->u.event_mon_list.fs_id;
        msg_p->handle = PVFS_HANDLE_NULL;
        msg_p->retry_flag = PVFS_MSGPAIR_RETRY;
        msg_p->comp_fn = event_mon_list_comp_fn;
        msg_p->svr_addr = sm_p->u.event_mon_list.addr_array[i];
    }
    return 1;
}

static int mgmt_event_mon_list_cleanup(PINT_client_sm *sm_p,
                                       job_status_s *js_p)
{
    int i = 0, errct = 0;
    PVFS_error error = js_p->error_code;

    /* store server-specific errors if requested and present */
    if ((error != 0) && (sm_p->u.event_mon_list.details != NULL))
    {
	sm_p->u.event_mon_list.details->count_exceeded = 0;

	for(i = 0; i < sm_p->u.event_mon_list.server_count; i++)
        {
	    if (sm_p->msgarray[i].op_status != 0)
	    {
		if (errct <
                    sm_p->u.event_mon_list.details->count_allocated)
		{
		    sm_p->u.event_mon_list.details->error[errct].error =
                        sm_p->msgarray[i].op_status;
		    sm_p->u.event_mon_list.details->error[errct].addr =
                        sm_p->msgarray[i].svr_addr;
		    errct++;
		}
		else
		{
		    sm_p->u.event_mon_list.details->count_exceeded = 1;
		}
	    }
	}
	sm_p->u.event_mon_list.details->count_used = errct;
	error = -PVFS_EDETAIL;
    }

    if (sm_p->msgarray && (sm_p->msgarray != &sm_p->msgpair))
    {
	free(sm_p->msgarray);
    }

    sm_p->error_code  = error;
    sm_p->op_complete = 1;

    return 0;
}

static int event_mon_list_comp_fn(void* v_p,
                                  struct PVFS_server_resp* resp_p,
                                  int i)
{
    int j = 0;
    PINT_client_sm *sm_p = (PINT_client_sm *) v_p;

    /* if this particular request was successful, then store the 
     * performance information in an array to be returned to caller
     */
    if (sm_p->msgarray[i].op_status == 0)
    {
        memcpy(sm_p->u.event_mon_list.event_matrix[i],
               resp_p->u.mgmt_event_mon.event_array,
               resp_p->u.mgmt_event_mon.event_count
               * sizeof(struct PVFS_mgmt_event));
    }
 
    /* if this is the last response, check all of the status values and 
     * return error code if any requests failed 
     */
    if (i == (sm_p->msgarray_count -1))
    {
        for(j = 0; j < sm_p->msgarray_count; j++)
        {
            if (sm_p->msgarray[j].op_status != 0)
            {
                return sm_p->msgarray[j].op_status;
            }
        }
    }
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
