/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pint-event.h"

static int setparam_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int setparam_work(
    PINT_server_op *s_op, job_status_s* js_p);

static int check_fs_id(PVFS_fs_id fs_id);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_work[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_setparam_sm =
{
	ST_prelude,
	"pvfs2_setparam_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_work[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setparam_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setparam_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 59 "src/server/setparam.sm"


/* setparam_work()
 *
 * actually does the "work" involved in setting a runtime server parameter
 */
static int setparam_work(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1, tmp_on = 0, old_event_on = 0;
    job_id_t tmp_id;
    uint64_t tmp_mask = 0;
    int32_t old_api_mask = 0, old_op_mask = 0;
    PVFS_handle tmp_handle = PVFS_HANDLE_NULL;
    struct server_configuration_s *user_opts;
    struct filesystem_configuration_s *fs_conf;
    char buf[16] = {0};
 
    PINT_STATE_DEBUG("work");

    switch(s_op->req->u.mgmt_setparam.param)
    {
        case PVFS_SERV_PARAM_GOSSIP_MASK:
            gossip_get_debug_mask(&tmp_on, &tmp_mask);
            s_op->resp.u.mgmt_setparam.old_value = tmp_mask;
            gossip_set_debug_mask(
                1, s_op->req->u.mgmt_setparam.value);
            js_p->error_code = 0;
            return(1);
        case PVFS_SERV_PARAM_INVALID:
            gossip_lerr("Error: mgmt_setparam for unknown parameter %d.\n",
                (int)s_op->req->u.mgmt_setparam.param);
            js_p->error_code = -PVFS_ENOSYS;
            return(1);
        case PVFS_SERV_PARAM_FSID_CHECK:
            s_op->resp.u.mgmt_setparam.old_value = 0;
            js_p->error_code = check_fs_id(
                (PVFS_fs_id)s_op->req->u.mgmt_setparam.value);
            return(1);
        case PVFS_SERV_PARAM_ROOT_CHECK:
            tmp_handle = (PVFS_handle)s_op->req->u.mgmt_setparam.value;
            s_op->resp.u.mgmt_setparam.old_value = 0;
            gossip_debug(GOSSIP_SERVER_DEBUG, " - ROOT_CHECK looking for"
                         " handle %Lu, on fs_id %d\n", Lu(tmp_handle),
                         s_op->req->u.mgmt_setparam.fs_id);
            ret = job_trove_dspace_verify(
                s_op->req->u.mgmt_setparam.fs_id, tmp_handle,
                0, s_op, 0, js_p, &tmp_id, server_job_context);
            return(ret);
        case PVFS_SERV_PARAM_EVENT_ON:
            ret = 0;
            PINT_event_get_masks(
                &old_event_on, &old_api_mask, &old_op_mask);
            PINT_event_set_masks(
                (int)s_op->req->u.mgmt_setparam.value,
                old_api_mask, old_op_mask);
            s_op->resp.u.mgmt_setparam.old_value = old_event_on;
            js_p->error_code = ret;
            return(1);
        case PVFS_SERV_PARAM_EVENT_MASKS:
            PINT_event_get_masks(
                &old_event_on, &old_api_mask, &old_op_mask);
            PINT_event_set_masks(old_event_on,
                (int32_t)(s_op->req->u.mgmt_setparam.value & 0x0FFFFFFFF),
                (int32_t)(s_op->req->u.mgmt_setparam.value >> 32));
            s_op->resp.u.mgmt_setparam.old_value = old_api_mask +
                ((int64_t)old_op_mask << 32);
            js_p->error_code = 0;
            return(1);
        case PVFS_SERV_PARAM_SYNC_META:
            user_opts = get_server_config_struct();
            fs_conf = PINT_config_find_fs_id(user_opts, 
                s_op->req->u.mgmt_setparam.fs_id);
            if(fs_conf)
            {
                if(s_op->req->u.mgmt_setparam.value)
                    fs_conf->trove_sync_meta = TROVE_SYNC;
                else
                    fs_conf->trove_sync_meta = 0;
            }
            js_p->error_code = 0;
            return(1);
        case PVFS_SERV_PARAM_SYNC_DATA:
            user_opts = get_server_config_struct();
            fs_conf = PINT_config_find_fs_id(user_opts, 
                s_op->req->u.mgmt_setparam.fs_id);
            if(fs_conf)
            {
                if(s_op->req->u.mgmt_setparam.value)
                {
                    snprintf(buf, 16, "%d,%d", s_op->req->u.mgmt_setparam.fs_id,
                             TROVE_SYNC);
                    PINT_flow_setinfo(NULL, FLOWPROTO_DATA_SYNC_MODE, buf);
                    fs_conf->trove_sync_data = TROVE_SYNC;
                }
                else
                {
                    snprintf(buf, 16, "%d,%d", s_op->req->u.mgmt_setparam.fs_id,
                             0);
                    PINT_flow_setinfo(NULL, FLOWPROTO_DATA_SYNC_MODE, buf);
                    fs_conf->trove_sync_data = 0;
                }
            }
            js_p->error_code = 0;
            return(1);
        case PVFS_SERV_PARAM_MODE:
            /* no work to do here; request scheduler has already handled */
            js_p->error_code = 0;
            return(1);
    }

    gossip_lerr("Error: mgmt_setparam for unknown parameter %d.\n",
                (int)s_op->req->u.mgmt_setparam.param);

    js_p->error_code = -PVFS_ENOSYS;
    return 1;
}

/* setparam_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int setparam_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");

    gossip_debug(GOSSIP_SERVER_DEBUG, " - setparam returning %d\n",
                 js_p->error_code);
    return(server_state_machine_complete(s_op));
}

/* check_fs_id()
 *
 * checks to see if a given fs id is valid
 *
 * returns 0 on success, -PVFS_error on failure
 */
static int check_fs_id(PVFS_fs_id fs_id)
{
    int ret = -PVFS_ENOENT, count = 1;
    TROVE_ds_position pos = TROVE_ITERATE_START;
    TROVE_keyval_s name;
    TROVE_coll_id tmp_coll;
    TROVE_op_id tmp_id;

    name.buffer = malloc(PVFS_NAME_MAX);
    if (!name.buffer)
    {
        ret = -PVFS_ENOMEM;
        goto check_failed;
    }
    name.buffer_sz = PVFS_NAME_MAX;

    while(count == 1)
    {
        ret = trove_collection_iterate(
            &pos, &name, &tmp_coll, &count, 0, 0, NULL, &tmp_id);

        if (ret == 0)
        {
            gossip_lerr("Error: unexpected trove behavior.\n");
            ret = -PVFS_EINVAL;
            goto free_name_buffer;
        }
        
        if (ret < 0)
        {
            goto free_name_buffer;
        }

        gossip_debug(GOSSIP_SERVER_DEBUG, "looking for fs_id: %d, "
                     "found %d.\n", (int)fs_id, (int)tmp_coll);

        if ((count > 0) && (tmp_coll == fs_id))
        {
            /* we found a matching collection */
            ret = 0;
            break;
        }
    }

free_name_buffer:
    free(name.buffer);
check_failed:

    return ret;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
