/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"

enum
{
    STATE_METAFILE = 7,
    STATE_SYMLINK = 8
};

static int setattr_cleanup(
    PINT_server_op *s_op, job_status_s *js_p);
static int setattr_setobj_attribs(
    PINT_server_op *s_op, job_status_s *js_p);
static int setattr_write_metafile_datafile_handles_if_required(
    PINT_server_op *s_op, job_status_s *js_p);
static int setattr_write_metafile_distribution_if_required(
    PINT_server_op *s_op, job_status_s *js_p);
static int setattr_write_symlink_target_if_required(
    PINT_server_op *s_op, job_status_s *js_p);
static int setattr_verify_attribs(
    PINT_server_op *s_op, job_status_s *js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_cleanup[];
static union PINT_state_array_values ST_verify_attribs[];
static union PINT_state_array_values ST_write_metafile_datafile_handles_if_required[];
static union PINT_state_array_values ST_write_metafile_distribution_if_required[];
static union PINT_state_array_values ST_write_symlink_target_if_required[];
static union PINT_state_array_values ST_setobj_attrib[];
static union PINT_state_array_values ST_final_response[];

struct PINT_state_machine_s pvfs2_set_attr_sm =
{
	ST_prelude,
	"pvfs2_set_attr_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_attribs,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_verify_attribs[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_verify_attribs,
(union PINT_state_array_values) STATE_METAFILE,
(union PINT_state_array_values) ST_write_metafile_datafile_handles_if_required,
(union PINT_state_array_values) STATE_SYMLINK,
(union PINT_state_array_values) ST_write_symlink_target_if_required,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setobj_attrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_write_metafile_datafile_handles_if_required[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_write_metafile_datafile_handles_if_required,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_write_metafile_distribution_if_required,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_write_metafile_distribution_if_required[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_write_metafile_distribution_if_required,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setobj_attrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_write_symlink_target_if_required[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_write_symlink_target_if_required,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_setobj_attrib,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_setobj_attrib[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_setobj_attribs,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) setattr_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 103 "src/server/set-attr.sm"


static int setattr_verify_attribs(
    PINT_server_op *s_op, job_status_s *js_p)
{
    PVFS_object_attr *a_p = NULL, *req_a_p = NULL;

    PINT_STATE_DEBUG("verify_attribs");

    a_p = &s_op->attr;
    req_a_p = &s_op->req->u.setattr.attr;

    gossip_debug(GOSSIP_SETATTR_DEBUG, "  attrs read from dspace:\n\t"
                 "[owner = %d, group = %d, perms = %o, type = %d]\n",
                 a_p->owner, a_p->group, a_p->perms, a_p->objtype);

    gossip_debug(GOSSIP_SETATTR_DEBUG, "  attrs read from request:\n\t"
                 "[owner = %d, group = %d, perms = %o, type = %d]\n",
                 req_a_p->owner, req_a_p->group, req_a_p->perms,
                 req_a_p->objtype);
    /*
      here we're enforcing that no one can change the type of the
      handle/object already stored once it's been set to a non-zero
      value.  (zero is not a valid object type meaning that it hasn't
      been assigned yet)
    */
    if (a_p->objtype && req_a_p->objtype &&
        (a_p->objtype != req_a_p->objtype))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG, "  handle %Lu is of type %d "
                     "and cannot be changed to type %d\n",
                     Lu(s_op->req->u.setattr.handle),
                     a_p->objtype, s_op->req->u.setattr.attr.objtype);

        /* set an error to bail out of set-attr processing */
        js_p->error_code = -PVFS_EACCES;
        return 1;
    }
    else if(!req_a_p->objtype)
    {
        /* if the requested object type is PVFS_TYPE_NONE, then the
         * setattr is only on the common attributes, so we use the
         * actual object type
         */
        req_a_p->objtype = a_p->objtype;
    }

    js_p->error_code = 0;

    if ((req_a_p->objtype == PVFS_TYPE_METAFILE) ||
        (a_p->objtype == PVFS_TYPE_METAFILE))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to a metafile\n",
                     Lu(s_op->req->u.setattr.handle));

        gossip_debug(
            GOSSIP_SETATTR_DEBUG, " *** dspace has dfile count %d and "
            "req has dfile count %d\n",
            a_p->u.meta.dfile_count, req_a_p->u.meta.dfile_count);
        gossip_debug(
            GOSSIP_SETATTR_DEBUG, " *** dspace has dist size %d and "
            "req has dist size %d\n",
            a_p->u.meta.dist_size, req_a_p->u.meta.dist_size);

        /* copy the dfile count before writing this object */
        if (req_a_p->mask & PVFS_ATTR_META_DFILES)
        {
            gossip_debug(
                GOSSIP_SETATTR_DEBUG," *** using dfile_count of %d\n",
                req_a_p->u.meta.dfile_count);
            a_p->u.meta.dfile_count = req_a_p->u.meta.dfile_count;
            js_p->error_code = STATE_METAFILE;
        }
        else
        {
            gossip_debug(GOSSIP_SETATTR_DEBUG,
                         " *** ignoring dfile_count of %d\n",
                         req_a_p->u.meta.dfile_count);
        }

        /* copy the dist size before writing this object */
        if (req_a_p->mask & PVFS_ATTR_META_DIST)
        {
            gossip_debug(GOSSIP_SETATTR_DEBUG,
                         " *** using dist_size of %d\n",
                         req_a_p->u.meta.dist_size);
            a_p->u.meta.dist_size = req_a_p->u.meta.dist_size;
            js_p->error_code = STATE_METAFILE;
        }
        else
        {
            gossip_debug(GOSSIP_SETATTR_DEBUG,
                         " *** ignoring dist_size of %d\n",
                         req_a_p->u.meta.dist_size);
        }
    }
    else if ((req_a_p->objtype == PVFS_TYPE_DATAFILE) ||
             (a_p->objtype == PVFS_TYPE_DATAFILE))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to a datafile\n",
                     Lu(s_op->req->u.setattr.handle));
    }
    else if ((req_a_p->objtype == PVFS_TYPE_DIRECTORY) ||
             (a_p->objtype == PVFS_TYPE_DIRECTORY))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to a directory\n",
                     Lu(s_op->req->u.setattr.handle));
    }
    else if ((req_a_p->objtype == PVFS_TYPE_SYMLINK) ||
             (a_p->objtype == PVFS_TYPE_SYMLINK))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to a symlink\n",
                     Lu(s_op->req->u.setattr.handle));

        if (req_a_p->mask & PVFS_ATTR_SYMLNK_ALL)
        {
            assert(req_a_p->u.sym.target_path_len > 0);
            assert(req_a_p->u.sym.target_path);

            gossip_debug(GOSSIP_SETATTR_DEBUG,
                         " symlink links handle %Lu to %s\n",
                         Lu(s_op->req->u.setattr.handle),
                         req_a_p->u.sym.target_path);

            a_p->u.sym.target_path_len = req_a_p->u.sym.target_path_len;
            a_p->u.sym.target_path = req_a_p->u.sym.target_path;
        }
        js_p->error_code = STATE_SYMLINK;
    }
    else if ((req_a_p->objtype == PVFS_TYPE_DIRDATA) ||
             (a_p->objtype == PVFS_TYPE_DIRDATA))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to a dirdata object\n",
                     Lu(s_op->req->u.setattr.handle));
    }
    else
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "  handle %Lu refers to something unknown\n",
                     Lu(s_op->req->u.setattr.handle));

        js_p->error_code = -PVFS_EACCES;
    }
    return 1;
}

static int setattr_setobj_attribs(PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t j_id;
    PVFS_object_attr *a_p = NULL;
    PVFS_object_attr *dspace_a_p = NULL;
    PVFS_ds_attributes *ds_attr = NULL;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("setobj_attribs");

    dspace_a_p = &s_op->attr;
    a_p = &s_op->req->u.setattr.attr;

    if (a_p->mask & PVFS_ATTR_META_DFILES)
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG, " request has dfile_count of "
                     "%d | dspace has %d\n",
                     s_op->req->u.setattr.attr.u.meta.dfile_count,
                     s_op->attr.u.meta.dfile_count);

        gossip_debug(GOSSIP_SETATTR_DEBUG, " writing count of %d to "
                     "disk\n", dspace_a_p->u.meta.dfile_count);
    }

    /*
      we have the attribs stored in the dspace, as well as the
      requested attribs to store.  overwrite the ones that are setable
      and specified by the mask value in the request; macro defined in
      pvfs2-storage.h
    */
    PVFS_object_attr_overwrite_setable(dspace_a_p, a_p);

    gossip_debug(
        GOSSIP_SETATTR_DEBUG,
        "  WRITING attrs: [owner = %d, group = %d\n\t"
        "perms = %o, type = %d, atime = %Lu, mtime = %Lu\n\t"
        "ctime = %Lu | dfile_count = %d | dist_size = %d]\n",
        dspace_a_p->owner, dspace_a_p->group, dspace_a_p->perms,
        dspace_a_p->objtype, Lu(dspace_a_p->atime),
        Lu(dspace_a_p->mtime), Lu(dspace_a_p->ctime),
        (int)dspace_a_p->u.meta.dfile_count,
        (int)dspace_a_p->u.meta.dist_size);

    /* translate attrs to storage attr format */
    ds_attr = &(s_op->ds_attr);
    PVFS_object_attr_to_ds_attr(dspace_a_p, ds_attr);

    ret = job_trove_dspace_setattr(
        s_op->req->u.setattr.fs_id, s_op->req->u.setattr.handle,
        ds_attr, PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.setattr.fs_id),
        s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

static int setattr_write_metafile_datafile_handles_if_required(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = 0, dfile_count = 0;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("write_metafile_datafile_handles_if_needed");

    gossip_debug(GOSSIP_SETATTR_DEBUG,
                 " request has dfile_count of %d | dspace has %d\n",
                 s_op->req->u.setattr.attr.u.meta.dfile_count,
                 s_op->attr.u.meta.dfile_count);

    /* verify that the requested dfile count is sane */
    dfile_count = s_op->req->u.setattr.attr.u.meta.dfile_count;
    if ((dfile_count < 1) || (dfile_count > PVFS_REQ_LIMIT_DFILE_COUNT))
    {
        gossip_err("The requested dfile count of %d is invalid; "
                   "aborting operation.\n", dfile_count);
        js_p->error_code = -PVFS_EOVERFLOW;
        return 1;
    }

    /* set up key and value structure for keyval write */
    s_op->key.buffer = Trove_Common_Keys[METAFILE_HANDLES_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[METAFILE_HANDLES_KEY].size;

    gossip_debug(GOSSIP_SETATTR_DEBUG,
                 "  metafile has %d datafiles associated with it\n",
                 s_op->req->u.setattr.attr.u.meta.dfile_count);

    s_op->val.buffer = s_op->req->u.setattr.attr.u.meta.dfile_array;
    s_op->val.buffer_sz = dfile_count * sizeof(PVFS_handle);

    gossip_debug(
        GOSSIP_SETATTR_DEBUG, "  writing %s [%Lu,%d,"
        "len %d]\n", (char *)s_op->key.buffer,
        Lu(s_op->req->u.setattr.handle), s_op->req->u.setattr.fs_id,
        s_op->val.buffer_sz);

    ret = job_trove_keyval_write(
        s_op->req->u.setattr.fs_id, s_op->req->u.setattr.handle,
        &(s_op->key), &(s_op->val),
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.setattr.fs_id),
        NULL, s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

static int setattr_write_metafile_distribution_if_required(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = 0;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("write_metafile_distribution_if_required");

    /* if we don't need to fill in the distribution, skip it */
    if (!(s_op->req->u.setattr.attr.mask & PVFS_ATTR_META_DIST))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "skipping distribution write\n");
        js_p->error_code = 0;
        return 1;
    }

    /* distribution should take up non-negative space :) */
    assert(s_op->req->u.setattr.attr.u.meta.dist_size >= 0);

    /* set up key and value structure for keyval write */
    s_op->key.buffer = Trove_Common_Keys[METAFILE_DIST_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[METAFILE_DIST_KEY].size;

    gossip_debug(GOSSIP_SETATTR_DEBUG,
                 "  metafile distribution size = %d\n",
                 (int)s_op->req->u.setattr.attr.u.meta.dist_size);

    s_op->val.buffer = s_op->req->u.setattr.attr.u.meta.dist;
    s_op->val.buffer_sz = s_op->req->u.setattr.attr.u.meta.dist_size;

    PINT_dist_encode(NULL, s_op->req->u.setattr.attr.u.meta.dist);    

    gossip_debug(
        GOSSIP_SERVER_DEBUG, "  writing %s [%Lu,%d,"
        "len %d]\n", (char *)s_op->key.buffer,
        Lu(s_op->req->u.setattr.handle), s_op->req->u.setattr.fs_id,
        s_op->val.buffer_sz);

    ret = job_trove_keyval_write(
        s_op->req->u.setattr.fs_id, s_op->req->u.setattr.handle,
        &(s_op->key), &(s_op->val),
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.setattr.fs_id),
        NULL, s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

static int setattr_write_symlink_target_if_required(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = 0;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("write_symlink_target_if_required");

    /* if we don't need to fill in the symlink target, skip it */
    if (!(s_op->req->u.setattr.attr.mask & PVFS_ATTR_SYMLNK_TARGET))
    {
        gossip_debug(GOSSIP_SETATTR_DEBUG,
                     "skipping symlink target write\n");
        js_p->error_code = 0;
        return 1;
    }

    assert(s_op->req->u.setattr.attr.u.sym.target_path_len > 0);
    assert(s_op->req->u.setattr.attr.u.sym.target_path);

    /* set up key and value structure for keyval write */
    s_op->key.buffer = Trove_Common_Keys[SYMLINK_TARGET_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[SYMLINK_TARGET_KEY].size;

    gossip_debug(GOSSIP_SETATTR_DEBUG,
                 "  symlink target_path_len = %d\n",
                 s_op->req->u.setattr.attr.u.sym.target_path_len);

    s_op->val.buffer = s_op->req->u.setattr.attr.u.sym.target_path;
    s_op->val.buffer_sz = s_op->req->u.setattr.attr.u.sym.target_path_len;

    gossip_debug(GOSSIP_SETATTR_DEBUG, "  writing %s [%Lu,%d,"
                 "len %d]\n", (char *)s_op->key.buffer,
                 Lu(s_op->req->u.setattr.handle),
                 s_op->req->u.setattr.fs_id,
                 s_op->val.buffer_sz);

    ret = job_trove_keyval_write(
        s_op->req->u.setattr.fs_id, s_op->req->u.setattr.handle,
        &(s_op->key), &(s_op->val),
        PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.setattr.fs_id),
        NULL, s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

/*
 * Function: setattr_cleanup
 *
 * Params:   server_op *b, 
 *           job_status_s *js_p
 *
 * Returns:  int
 *
 * Synopsis: free memory and return
 *           
 */
static int setattr_cleanup(PINT_server_op *s_op, job_status_s *js_p)
{
    PINT_STATE_DEBUG("setattr_cleanup");
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

