/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <assert.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "gossip.h"

enum
{
    UPDATE_DIR_ATTR_REQUIRED = 133
};

static int rmdirent_verify_parent_metadata_and_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_remove_directory_entry(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_check_for_req_dir_update(
    PINT_server_op *s_op, job_status_s *js_p);
static int rmdirent_update_directory_attr(
    PINT_server_op *s_op, job_status_s *js_p);
static int rmdirent_read_directory_entry(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_read_directory_entry_failure(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_remove_directory_entry_failure(
    PINT_server_op *s_op, job_status_s* js_p);
static int rmdirent_setup_resp(
    PINT_server_op *s_op, job_status_s* js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_verify_parent_metadata_and_read_directory_entry_handle[];
static union PINT_state_array_values ST_read_directory_entry[];
static union PINT_state_array_values ST_read_directory_entry_failure[];
static union PINT_state_array_values ST_remove_directory_entry[];
static union PINT_state_array_values ST_remove_directory_entry_failure[];
static union PINT_state_array_values ST_check_for_req_dir_update[];
static union PINT_state_array_values ST_update_directory_attr[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_rmdirent_sm =
{
	ST_prelude,
	"pvfs2_rmdirent_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_parent_metadata_and_read_directory_entry_handle,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_verify_parent_metadata_and_read_directory_entry_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_verify_parent_metadata_and_read_directory_entry_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_directory_entry,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_directory_entry[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_read_directory_entry,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_remove_directory_entry,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_read_directory_entry_failure
};

static union PINT_state_array_values ST_read_directory_entry_failure[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_read_directory_entry_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_remove_directory_entry[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_remove_directory_entry,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_check_for_req_dir_update,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_remove_directory_entry_failure
};

static union PINT_state_array_values ST_remove_directory_entry_failure[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_remove_directory_entry_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_check_for_req_dir_update[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_check_for_req_dir_update,
(union PINT_state_array_values) UPDATE_DIR_ATTR_REQUIRED,
(union PINT_state_array_values) ST_update_directory_attr,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_update_directory_attr[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_update_directory_attr,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) rmdirent_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 128 "src/server/rmdirent.sm"


static int rmdirent_verify_parent_metadata_and_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t i;

    PINT_STATE_DEBUG("verify_parent_metadata_and_"
                     "read_directory_entry_handle");
    PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "rmdirent entry: %s\n",
        s_op->req->u.rmdirent.entry);

    /* set up key and value structures to read directory entry */
    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;

    /* we will read the dirdata handle from the entry into the
     * rmdirent scratch space */
    s_op->val.buffer = &s_op->u.rmdirent.dirdata_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    gossip_debug(
        GOSSIP_SERVER_DEBUG,
        "  reading dirdata handle (coll_id = 0x%x, handle = %Lu, "
        "key = %s (%d), val_buf = %p (%d))\n",
        s_op->req->u.rmdirent.fs_id,
        Lu(s_op->req->u.rmdirent.parent_handle),
        (char *)s_op->key.buffer,
        s_op->key.buffer_sz,
        s_op->val.buffer,
        s_op->val.buffer_sz);

    ret = job_trove_keyval_read(
        s_op->req->u.rmdirent.fs_id,
        s_op->req->u.rmdirent.parent_handle,
        &s_op->key,
        &s_op->val,
        0,
        NULL,
        s_op,
        0,
        js_p,
        &i,
        server_job_context);

    return ret;
}

/* Function: rmdirent_read_directory_entry
 *
 * Synopsis: In order to return the handle of the removed entry (which
 * is part of the rmdirent response), we must read the directory entry
 * prior to removing it.
 */
static int rmdirent_read_directory_entry(PINT_server_op *s_op,
					 job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;

    PINT_STATE_DEBUG("read_directory_entry");

    gossip_debug(GOSSIP_SERVER_DEBUG,
		 "  reading from dirent handle = %Lu, name = %s\n",
		 Lu(s_op->u.rmdirent.dirdata_handle),
		 s_op->req->u.rmdirent.entry);

    /* initialize keyval prior to read call
     *
     * We will read the handle into the rmdirent scratch space
     * (s_op->u.rmdirent.entry_handle).
     */
    s_op->key.buffer = s_op->req->u.rmdirent.entry;
    s_op->key.buffer_sz = strlen(s_op->req->u.rmdirent.entry) + 1;
    s_op->val.buffer = &s_op->u.rmdirent.entry_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    ret = job_trove_keyval_read(
        s_op->req->u.rmdirent.fs_id,
        s_op->u.rmdirent.dirdata_handle,
        &s_op->key,
        &s_op->val,
        0,
        NULL,
        s_op,
        0,
        js_p,
        &j_id,
        server_job_context);

    return ret;
}

/* Function: rmdirent_read_directory_entry_failure
 *
 * The purpose of this state is simply to parse the error value from a
 * failed direntry read operation (trove_keyval_read), convert it into
 * an error to return to the user if possible, and print an error if
 * something unexpected has occurred.
 *
 * This state always returns 1, and it allows another function to
 * handle actually returning the error value.
 */
static int rmdirent_read_directory_entry_failure(PINT_server_op *s_op,
						 job_status_s *js_p)
{
    PINT_STATE_DEBUG("read_directory_entry_failure");

    switch (js_p->error_code)
    {
	case -TROVE_ENOENT:
	    js_p->error_code = -PVFS_ENOENT;
	    break;
	default:
	    gossip_err("rmdirent_read_directory_entry_failure: "
                       "unexpected error %d\n", js_p->error_code);
	    break;
    }
    return 1;
}

/*
 * Function: rmdirent_remove_directory_entry
 *
 * Synopsis: posts a trove keyval remove to remove the directory entry
 * from the dirdata object.
 *           
 */
static int rmdirent_remove_directory_entry(PINT_server_op *s_op,
                                           job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("remove_directory_entry");

    /* set up key and structure for keyval remove */
    s_op->key.buffer = s_op->req->u.rmdirent.entry;
    s_op->key.buffer_sz = strlen(s_op->req->u.rmdirent.entry) + 1;

    gossip_debug(GOSSIP_SERVER_DEBUG, "  removing entry %s from dirdata "
                 "object (handle = %Lu)\n", s_op->req->u.rmdirent.entry,
                 Lu(s_op->u.rmdirent.dirdata_handle));

    ret = job_trove_keyval_remove(
        s_op->req->u.rmdirent.fs_id, s_op->u.rmdirent.dirdata_handle,
        &s_op->key, PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.rmdirent.fs_id),
        NULL, s_op, 0, js_p, &j_id, server_job_context);

    if (s_op->req->u.rmdirent.parent_atime ||
        s_op->req->u.rmdirent.parent_mtime ||
        s_op->req->u.rmdirent.parent_ctime)
    {
        s_op->u.rmdirent.dir_attr_update_required = 1;
    }
    return ret;
}

static int rmdirent_check_for_req_dir_update(
    PINT_server_op *s_op, job_status_s *js_p)
{
    if ((js_p->error_code == 0) &&
        (s_op->u.rmdirent.dir_attr_update_required))
    {
        js_p->error_code = UPDATE_DIR_ATTR_REQUIRED;
    }
    return 1;
}

static int rmdirent_update_directory_attr(
    PINT_server_op *s_op, job_status_s *js_p)
{
    int ret = -1;
    job_id_t j_id;
    PVFS_object_attr tmp_attr, *tmp_attr_ptr = &tmp_attr;
    PVFS_object_attr *dspace_attr = NULL;
    PVFS_ds_attributes *ds_attr = NULL;
    struct server_configuration_s *user_opts = get_server_config_struct();

    PINT_STATE_DEBUG("update_directory_entry");

    if (js_p->error_code != UPDATE_DIR_ATTR_REQUIRED)
    {
        PVFS_perror_gossip("previous keyval remove failed",
                           js_p->error_code);
        return 1;
    }

    memset(&tmp_attr, 0, sizeof(PVFS_object_attr));
    dspace_attr = &s_op->attr;
    ds_attr = &(s_op->ds_attr);

    PVFS_object_attr_overwrite_setable(tmp_attr_ptr, dspace_attr);

    /* overwrite all non-null attribute time fields */
    if (s_op->req->u.rmdirent.parent_atime)
    {
        tmp_attr_ptr->atime = s_op->req->u.rmdirent.parent_atime;
    }
    if (s_op->req->u.rmdirent.parent_mtime)
    {
        tmp_attr_ptr->mtime = s_op->req->u.rmdirent.parent_mtime;
    }
    if (s_op->req->u.rmdirent.parent_ctime)
    {
        tmp_attr_ptr->ctime = s_op->req->u.rmdirent.parent_ctime;
    }

    ds_attr = &(s_op->ds_attr);
    PVFS_object_attr_to_ds_attr(tmp_attr_ptr, ds_attr);

    ret = job_trove_dspace_setattr(
        s_op->req->u.rmdirent.fs_id, s_op->req->u.rmdirent.parent_handle,
        ds_attr, PINT_config_get_trove_sync_meta(
            user_opts, s_op->req->u.rmdirent.fs_id),
        s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

/* Function: rmdirent_read_directory_entry_failure
 *
 * The purpose of this state is simply to parse the error value from a
 * failed direntry remove operation (trove_keyval_remove), convert it
 * into an error to return to the user if possible, and print an error
 * if something unexpected has occurred.
 *
 * NOTE: we shouldn't ever actually hit this state, because nothing
 * else should be modifying trove in such a way that the keyval isn't
 * there at this point, because the keyval read has to have succeeded
 * for us to get this far.
 *
 * This state always returns 1, and it allows another function to
 * handle actually returning the error value.
 */
static int rmdirent_remove_directory_entry_failure(PINT_server_op *s_op,
						   job_status_s *js_p)
{
    PINT_STATE_DEBUG("remove_directory_entry_failure");

    assert(js_p->error_code != -TROVE_ENOENT);
	    
    switch (js_p->error_code)
    {
	case -TROVE_ENOENT:
	    js_p->error_code = -PVFS_ENOENT;
	    break;
	default:
	    break;
    }

    gossip_lerr("unexpected error %d\n", js_p->error_code);
    return 1;
}

static int rmdirent_setup_resp(PINT_server_op *s_op,
                               job_status_s* js_p)
{
    PINT_STATE_DEBUG("setup_resp");

    /* Set the handle if it was removed */
    if(js_p->error_code == 0)
    {
	/*
          we return the handle from the directory entry in the
          response
        */
	s_op->resp.u.rmdirent.entry_handle =
            s_op->u.rmdirent.entry_handle;
	gossip_debug(GOSSIP_SERVER_DEBUG,
		     "  succeeded; returning handle %Lu in response\n",
		     Lu(s_op->resp.u.rmdirent.entry_handle));
    }
    else
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "  sending error response\n");
    }

    /* NOTE: we _intentionally_ leave the error_code field the way that
     * we found it, so that later states can use it to set the resp.status
     * field.
     */
    return(1);
}

static int rmdirent_cleanup(PINT_server_op *s_op,
                            job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");

    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
