/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

#include <string.h>
#include <stddef.h>
#include <assert.h>
#include <stdio.h>
#include <malloc.h>

#include "server-config.h"
#include "pvfs2-server.h"
#include "pvfs2-attr.h"
#include "str-utils.h"
#include "pint-util.h"

enum 
{
    STATE_ENOTDIR = 22,
    STATE_NOMORESEGS = 23
};

static int lookup_init(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_cleanup(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_read_object_metadata(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_verify_object_metadata(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_read_directory_entry(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s* js_p);
static int lookup_setup_resp(
    PINT_server_op *s_op, job_status_s* js_p);

extern PINT_server_trove_keys_s Trove_Common_Keys[];

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_read_object_metadata[];
static union PINT_state_array_values ST_read_directory_entry_handle[];
static union PINT_state_array_values ST_read_directory_entry[];
static union PINT_state_array_values ST_verify_object_metadata[];
static union PINT_state_array_values ST_setup_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_lookup_sm =
{
	ST_prelude,
	"pvfs2_lookup_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_init,
(union PINT_state_array_values) STATE_ENOTDIR,
(union PINT_state_array_values) ST_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_read_object_metadata
};

static union PINT_state_array_values ST_read_object_metadata[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_read_object_metadata,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_verify_object_metadata,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_verify_object_metadata[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_verify_object_metadata,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_directory_entry_handle,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_directory_entry_handle[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_read_directory_entry_handle,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_directory_entry,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_read_directory_entry[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_read_directory_entry,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_read_object_metadata,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_setup_resp
};

static union PINT_state_array_values ST_setup_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_setup_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) lookup_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 116 "src/server/lookup.sm"


/*
 * Function: lookup_init
 *
 * Synopsis: initializes internal structures and posts job to request
 * scheduler.
 *
 * Assumes req structure holds a valid path.
 *
 * Initializes segp, seg_ct, seg_nr fields in s_op->u.lookup.
 *
 * Allocates memory for handle and attribute arrays that will be
 * returned in the response.
 *
 * Note: memory is allocated as one big chunk, pointed to by
 * s_op->resp.u.lookup_path.handle_array.
 *
 */
static int lookup_init(PINT_server_op *s_op, job_status_s* js_p)
{
    char *ptr = NULL;

    PINT_STATE_DEBUG("init");

    /* fill in the lookup portion of the PINT_server_op */
    s_op->u.lookup.segp = NULL;
    s_op->u.lookup.seg_nr = 0;
    s_op->u.lookup.seg_ct = PINT_string_count_segments(
        s_op->req->u.lookup_path.path);
    s_op->u.lookup.handle_ct = 0;
    s_op->u.lookup.attr_ct = 0;

    if ((s_op->u.lookup.seg_ct < 0) ||
        (s_op->u.lookup.seg_ct > PVFS_REQ_LIMIT_PATH_SEGMENT_COUNT))
    {
	gossip_err("  invalid path %s (bad segment count); "
                   "sending error response\n",
		   s_op->req->u.lookup_path.path);
	js_p->error_code = -PVFS_ENOTDIR;
        return 0;
    }

    /* allocate the internal ds_attr_array */
    s_op->u.lookup.ds_attr_array = (PVFS_ds_attributes *)
        malloc(s_op->u.lookup.seg_ct * sizeof(PVFS_ds_attributes));
    assert(s_op->u.lookup.ds_attr_array);

    /* allocate memory
     *
     * Note: all memory is allocated in a single block,
     * pointed to by s_op->resp.u.lookup_path.handle_array
     */
    ptr = malloc(s_op->u.lookup.seg_ct *
                 (sizeof(PVFS_handle) + sizeof(PVFS_object_attr)));
    if (!ptr)
    {
        js_p->error_code = -PVFS_ENOMEM;
        return 1;
    }

    s_op->resp.u.lookup_path.handle_array = (PVFS_handle *)ptr;
    ptr += (s_op->u.lookup.seg_ct * sizeof(PVFS_handle));

    s_op->resp.u.lookup_path.attr_array = (PVFS_object_attr *)ptr;

    js_p->error_code = 0;
    return 1;
}

/*
 * Function: lookup_read_object_metadata
 *
 * Synopsis: Given an object handle, looks up the attributes
 * (metadata) for that handle.
 *
 * Initializes key and value structures to direct metadata:
 * - if this is the starting (base) handle, store in
 *   s_op->u.lookup.base_attr
 * - otherwise store it in the appropriate slot in the resp handle array
 *
 * Posts the keyval read to trove.
 */
static int lookup_read_object_metadata(
    PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;
    PVFS_handle handle = PVFS_HANDLE_NULL;
    PVFS_ds_attributes *ds_attr = NULL;

    PINT_STATE_DEBUG("read_object_metadata");

    assert(s_op->u.lookup.seg_nr <= s_op->u.lookup.seg_ct);

    /* use the base handle if we haven't looked up a segment yet */
    if (s_op->u.lookup.seg_nr == 0)
    {
        handle = s_op->req->u.lookup_path.starting_handle;
        ds_attr = &(s_op->u.lookup.ds_attr_array[0]);
    }
    else
    {
        handle = s_op->resp.u.lookup_path.handle_array[
            s_op->u.lookup.seg_nr-1];
        ds_attr = &(s_op->u.lookup.ds_attr_array[
                        s_op->u.lookup.seg_nr - 1]);
    }

    /* update our successful handle read count */
    s_op->u.lookup.handle_ct++;

    /* get the dspace attributes/metadata */
    ret = job_trove_dspace_getattr(
        s_op->req->u.lookup_path.fs_id, handle, s_op, ds_attr,
        0, js_p, &j_id, server_job_context);

    return ret;
}

/*
 * Function: lookup_verify_object_metadata
 *
 * Synopsis: Examine the metadata returned from the prelude sm.  If
 * the metadata is for a directory, prepare to read the handle of the
 * next segment, if there is one.  If the metadata is for a file,
 * prepare to send a response.
 *
 * If the object is a directory, this function sets the
 * s_op->u.lookup.segp value to point to the next segment to look up;
 * this is used in lookup_read_directory_entry.
 *
 * This function does not post an operation, but rather returns 1
 * immediately.
 */
static int lookup_verify_object_metadata(
    PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_object_attr *a_p = NULL;
    PVFS_ds_attributes *ds_attr = NULL;

    PINT_STATE_DEBUG("verify_object_metadata");

    if (s_op->u.lookup.seg_nr == 0)
    {
        a_p = &s_op->attr;
        ds_attr = &(s_op->u.lookup.ds_attr_array[0]);
    }
    else
    {
        a_p = &s_op->resp.u.lookup_path.attr_array[
            s_op->u.lookup.seg_nr - 1];
        ds_attr = &(s_op->u.lookup.ds_attr_array[
                        s_op->u.lookup.seg_nr - 1]);
    }

    PVFS_ds_attr_to_object_attr(ds_attr, a_p);
    a_p->mask = PVFS_ATTR_COMMON_ALL;

    /* update our successful attr read count */
    s_op->u.lookup.attr_ct++;

    assert(((a_p->objtype == PVFS_TYPE_DIRECTORY) ||
            (a_p->objtype == PVFS_TYPE_METAFILE)  ||
            (a_p->objtype == PVFS_TYPE_SYMLINK)));

    gossip_debug(
        GOSSIP_SERVER_DEBUG, "  attrs = (owner = %d, group = %d, "
        "perms = %o, type = %d)\n", a_p->owner, a_p->group,
        a_p->perms, a_p->objtype);

    /* if we hit a metafile, we are done */
    if (a_p->objtype == PVFS_TYPE_METAFILE)
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "  object is a metafile; "
                     "halting lookup and sending response\n");

	js_p->error_code = STATE_ENOTDIR;
	return 1;
    }

    /*
      if we hit a symlink, we're done; client will pick up the pieces
      and continue to resolve the symlink if required
    */
    if (a_p->objtype == PVFS_TYPE_SYMLINK)
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "  object is a symlink; "
                     "halting lookup and sending response\n");

	js_p->error_code = STATE_ENOTDIR;
	return 1;
    }

    /* if we looked up all the segments, we are done */
    if (s_op->u.lookup.seg_nr == s_op->u.lookup.seg_ct)
    {
	gossip_debug(GOSSIP_SERVER_DEBUG, "  no more segments in path; "
                     "sending response\n");

	js_p->error_code = STATE_NOMORESEGS;
	return 1;
    }

    /* if we reach this point, the object is a directory.  Verify that we
     * have execute permission on the directory before continuing traversal
     */
    js_p->error_code = PINT_check_mode(a_p, s_op->req->credentials.uid,
        s_op->req->credentials.gid, PINT_ACCESS_EXECUTABLE);
    if(js_p->error_code != 0)
    {
        /* doesn't look like we have permission to traverse directory; bail
         * out
         */
        return(1);
    }

    /* find the segment that we should look up in the directory */
    ret = PINT_string_next_segment(
        s_op->req->u.lookup_path.path, &s_op->u.lookup.segp,
        &s_op->u.lookup.segstate);

    assert(ret == 0);

    gossip_debug(GOSSIP_SERVER_DEBUG, "  object is a directory; will be "
                 "looking for handle for segment \"%s\" in a bit\n",
		 s_op->u.lookup.segp);


    return 1;
}

/*
 * Function: lookup_read_directory_entry_handle
 *
 * Synopsis: Given a directory handle, look up the handle used to
 * store directory entries for this directory.
 *
 * Initializes key and value structures to direct handle into
 * s_op->u.lookup.dirent_handle, which is where we always store the
 * handle used to read directory entries.  The handle to use for the
 * read is either:
 * - the starting handle from the req (if we haven't looked up a
 *   segment yet), or
 * - the previous segment's handle (from response handle array).
 *
 * Posts the keyval read to trove.
 */
static int lookup_read_directory_entry_handle(
    PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_handle handle = PVFS_HANDLE_NULL;
    job_id_t j_id;

    PINT_STATE_DEBUG("read_directory_entry_handle");

    /* use the base handle if we haven't looked up a segment yet */
    if (s_op->u.lookup.seg_nr == 0)
    {
        handle = s_op->req->u.lookup_path.starting_handle;
    }
    else
    {
        handle = s_op->resp.u.lookup_path.handle_array[
            s_op->u.lookup.seg_nr-1];
    }

    gossip_debug(GOSSIP_SERVER_DEBUG,
		 "  reading dirent handle value from handle %Lu\n",
		 Lu(handle));

    s_op->key.buffer = Trove_Common_Keys[DIR_ENT_KEY].key;
    s_op->key.buffer_sz = Trove_Common_Keys[DIR_ENT_KEY].size;
    s_op->val.buffer = &s_op->u.lookup.dirent_handle;
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    ret = job_trove_keyval_read(
        s_op->req->u.lookup_path.fs_id, handle, &s_op->key, &s_op->val,
        0, NULL, s_op, 0, js_p, &j_id, server_job_context);

    return ret;
}

/*
 * Function: lookup_read_directory_entry
 *
 * Synopsis: Given a handle for a dspace holding directory entries,
 * look up the current segment and obtain its handle.
 */
static int lookup_read_directory_entry(
    PINT_server_op *s_op, job_status_s* js_p)
{
    int ret = -PVFS_EINVAL;
    job_id_t j_id;

    PINT_STATE_DEBUG("read_directory_entry");

    gossip_debug(
        GOSSIP_SERVER_DEBUG, "  reading from dirent handle = "
        "%Lu, segment = %s (len=%d)\n", Lu(s_op->u.lookup.dirent_handle),
        s_op->u.lookup.segp, (int) strlen(s_op->u.lookup.segp));

    s_op->key.buffer = s_op->u.lookup.segp;
    s_op->key.buffer_sz = strlen(s_op->u.lookup.segp) + 1;
    s_op->val.buffer =
        &s_op->resp.u.lookup_path.handle_array[s_op->u.lookup.seg_nr];
    s_op->val.buffer_sz = sizeof(PVFS_handle);

    /*
      NOTE: if this operation fails, seg_nr will indicate one too many
      valid segments; this is addressed in lookup_send_response.
    */
    s_op->u.lookup.seg_nr++;

    ret = job_trove_keyval_read(
        s_op->req->u.lookup_path.fs_id, s_op->u.lookup.dirent_handle,
        &s_op->key, &s_op->val, 0, NULL, s_op, 0, js_p, &j_id,
        server_job_context);

    return ret;
}


static int lookup_setup_resp(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("setup_resp");

    /*
      NOTE: we may have handle_count N with attr_count N-1 in the case
      that another meta-server needs to continue with the path (attr)
      lookup.  otherwise, we're returning N handles with N attrs.

      # actually completed are one less than the respective counts
    */
    s_op->resp.u.lookup_path.handle_count = s_op->u.lookup.handle_ct - 1;
    s_op->resp.u.lookup_path.attr_count = s_op->u.lookup.attr_ct - 1;

    if (s_op->resp.u.lookup_path.handle_count ||
        s_op->resp.u.lookup_path.attr_count)
    {
        js_p->error_code = 0;
    }
    else if(js_p->error_code < 0)
    {
        /* preserve error code in this case and fall through */
    }
    else
    {
        js_p->error_code = -PVFS_ENOENT;
    }

    gossip_debug(GOSSIP_SERVER_DEBUG, "  sending '%s' response with %d "
                 "handle(s) and %d attr(s)\n",
                 (js_p->error_code ? "error" : "success"),
                 s_op->resp.u.lookup_path.handle_count,
                 s_op->resp.u.lookup_path.attr_count);

    if(js_p->error_code == 0)
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "path: %s, handle: %Lu\n",
            s_op->req->u.lookup_path.path,
            Lu(s_op->resp.u.lookup_path.handle_array[s_op->resp.u.lookup_path.handle_count-1]));
    }
    else
    {
        PINT_ACCESS_DEBUG(s_op, GOSSIP_ACCESS_DEBUG, "path: %s, lookup failed\n",
            s_op->req->u.lookup_path.path);
    }

    return 1;
}

/*
 * Function: lookup_cleanup
 *
 * Synopsis: Free memory allocated during request processing.
 *
 * There are a bunch of regions that must be freed after processing
 * completes:
 * - decoded request (s_op->decoded)
 * - encoded request (s_op->unexp_bmi_buff.buffer)
 * - encoded response (s_op->encoded)
 * - original (decoded) response (s_op->resp)
 * - dynamically allocated space (in this case 
 *   s_op->resp.u.lookup_path.handle_array)
 * - the server operation structure itself
 */
static int lookup_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");
    
    if (s_op->resp.u.lookup_path.handle_array)
    {
        free(s_op->resp.u.lookup_path.handle_array);
        s_op->resp.u.lookup_path.handle_array = NULL;
    }

    if (s_op->u.lookup.ds_attr_array)
    {
        free(s_op->u.lookup.ds_attr_array);
        s_op->u.lookup.ds_attr_array = NULL;
    }
    return(server_state_machine_complete(s_op));
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
