/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2001 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include "pvfs2-server.h"

static int iterate_handles_cleanup(PINT_server_op *s_op, job_status_s* js_p);
static int iterate_handles_do_work(PINT_server_op *s_op, job_status_s* js_p);
static int iterate_handles_fill_resp(PINT_server_op *s_op, job_status_s* js_p);

static union PINT_state_array_values ST_prelude[];
static union PINT_state_array_values ST_do_work[];
static union PINT_state_array_values ST_fill_resp[];
static union PINT_state_array_values ST_final_response[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_iterate_handles_sm =
{
	ST_prelude,
	"pvfs2_iterate_handles_sm"
};
static union PINT_state_array_values ST_prelude[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_prelude_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_do_work
};

static union PINT_state_array_values ST_do_work[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) iterate_handles_do_work,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_fill_resp
};

static union PINT_state_array_values ST_fill_resp[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) iterate_handles_fill_resp,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_final_response
};

static union PINT_state_array_values ST_final_response[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_final_response_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) iterate_handles_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 54 "src/server/iterate-handles.sm"


/* iterate_handles_cleanup()
 *
 * cleans up any resources consumed by this state machine and ends
 * execution of the machine
 */
static int iterate_handles_cleanup(PINT_server_op *s_op, job_status_s* js_p)
{
    PINT_STATE_DEBUG("cleanup");

    if(s_op->resp.u.mgmt_iterate_handles.handle_array)
	free(s_op->resp.u.mgmt_iterate_handles.handle_array);

    return(server_state_machine_complete(s_op));
}


/* iterate_handles_do_work()
 *
 * actually performs work necessary to retrieve handles
 */
static int iterate_handles_do_work(PINT_server_op *s_op, job_status_s* js_p)
{
    job_id_t tmp_id;

    PINT_STATE_DEBUG("do_work");

    /* allocate memory to hold handles */
    s_op->resp.u.mgmt_iterate_handles.handle_array
	= (PVFS_handle*)malloc(s_op->req->u.mgmt_iterate_handles.handle_count *
	sizeof(PVFS_handle));
    if(!s_op->resp.u.mgmt_iterate_handles.handle_array)
    {
	js_p->error_code = -PVFS_ENOMEM;
	return(1);
    }
    
    s_op->resp.u.mgmt_iterate_handles.position
	= s_op->req->u.mgmt_iterate_handles.position;

    return(job_trove_dspace_iterate_handles(
	s_op->req->u.mgmt_iterate_handles.fs_id,
	s_op->resp.u.mgmt_iterate_handles.position,
	s_op->resp.u.mgmt_iterate_handles.handle_array,
	s_op->req->u.mgmt_iterate_handles.handle_count,
	0,
	NULL,
	s_op,
	0,
	js_p,
	&tmp_id,
	server_job_context));
}

/* iterate_handles_fill_resp()
 *
 * gathers results from job status for response
 */
static int iterate_handles_fill_resp(PINT_server_op *s_op, job_status_s* js_p)
{
    if(js_p->error_code != 0)
    {
	/* propigate error and let final_response handle it */
	return(1);
    }

    s_op->resp.u.mgmt_iterate_handles.handle_count = js_p->count;
    s_op->resp.u.mgmt_iterate_handles.position = js_p->position;

    return(1);
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */

