/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup sysint
 *
 *  PVFS2 system interface routines for creating symlinks.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"
#include "pint-util.h"
#include "ncache.h"

extern job_context_id pint_client_sm_context;

enum
{
    SYMLINK_RETRY = 170
};

static int symlink_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_dspace_create_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_dspace_create_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_crdirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_crdirent_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_setattr_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_setattr_failure(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_delete_handle_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int symlink_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int symlink_create_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int symlink_setattr_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int symlink_crdirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);
static int symlink_delete_handle_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_symlink_parent_getattr[];
static union PINT_state_array_values ST_dspace_create_setup_msgpair[];
static union PINT_state_array_values ST_dspace_create_xfer_msgpair[];
static union PINT_state_array_values ST_dspace_create_failure[];
static union PINT_state_array_values ST_crdirent_setup_msgpair[];
static union PINT_state_array_values ST_crdirent_xfer_msgpair[];
static union PINT_state_array_values ST_crdirent_failure[];
static union PINT_state_array_values ST_symlink_setattr_setup_msgpair[];
static union PINT_state_array_values ST_symlink_setattr_xfer_msgpair[];
static union PINT_state_array_values ST_symlink_setattr_failure[];
static union PINT_state_array_values ST_delete_handle_setup_msgpair[];
static union PINT_state_array_values ST_delete_handle_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_symlink_sm =
{
	ST_init,
	"pvfs2_client_symlink_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_symlink_parent_getattr
};

static union PINT_state_array_values ST_symlink_parent_getattr[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_client_getattr_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_dspace_create_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_dspace_create_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_dspace_create_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_dspace_create_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_dspace_create_failure
};

static union PINT_state_array_values ST_dspace_create_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_symlink_setattr_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_dspace_create_failure
};

static union PINT_state_array_values ST_dspace_create_failure[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_dspace_create_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_symlink_setattr_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_setattr_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_symlink_setattr_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_symlink_setattr_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_crdirent_setup_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_symlink_setattr_failure
};

static union PINT_state_array_values ST_symlink_setattr_failure[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_setattr_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handle_setup_msgpair
};

static union PINT_state_array_values ST_crdirent_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_crdirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_crdirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_failure
};

static union PINT_state_array_values ST_crdirent_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_crdirent_failure
};

static union PINT_state_array_values ST_crdirent_failure[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_crdirent_failure,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_delete_handle_setup_msgpair
};

static union PINT_state_array_values ST_delete_handle_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_delete_handle_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_delete_handle_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_delete_handle_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) symlink_cleanup,
(union PINT_state_array_values) SYMLINK_RETRY,
(union PINT_state_array_values) ST_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 174 "src/client/sysint/sys-symlink.sm"


/** Initiate creation of a new symlink object on some server.
 */
PVFS_error PVFS_isys_symlink(
    char *entry_name,
    PVFS_object_ref parent_ref,
    char *target,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sysresp_symlink *resp,
    PVFS_sys_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_isys_symlink entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) ||
        (entry_name == NULL) || (resp == NULL) || (target == NULL))
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    if ((attr.mask & PVFS_ATTR_SYS_ALL_SETABLE) !=
        PVFS_ATTR_SYS_ALL_SETABLE)
    {
        gossip_lerr("PVFS_isys_symlink() failure: invalid attributes "
                    "specified\n");
        return ret;
    }

    if (((strlen(entry_name) + 1) > PVFS_REQ_LIMIT_SEGMENT_BYTES) ||
        ((strlen(target) + 1) > PVFS_REQ_LIMIT_SEGMENT_BYTES))
    {
        return -PVFS_ENAMETOOLONG;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->u.sym.link_name = entry_name;
    sm_p->u.sym.link_target = target;
    sm_p->u.sym.sym_resp = resp;
    PVFS_util_copy_sys_attr(&sm_p->u.sym.sys_attr, &attr);
    sm_p->u.sym.stored_error_code = 0;
    sm_p->u.sym.retry_count = 0;
    sm_p->object_ref = parent_ref;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Symlinking %s under parent handle %Lu "
        "on fs %d to %s\n", entry_name, Lu(parent_ref.handle),
        parent_ref.fs_id, target);

    return PINT_client_state_machine_post(
        sm_p, PVFS_SYS_SYMLINK, op_id, user_ptr);
}

/** Create a new symlink object on some server.
 */
PVFS_error PVFS_sys_symlink(
    char *entry_name,
    PVFS_object_ref parent_ref,
    char *target,
    PVFS_sys_attr attr,
    PVFS_credentials *credentials,
    PVFS_sysresp_symlink *resp)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_sys_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "PVFS_sys_symlink entered\n");

    ret = PVFS_isys_symlink(entry_name, parent_ref, target, attr,
                            credentials, resp, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_isys_symlink call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_sys_wait(op_id, "symlink", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_sys_wait call", ret);
            error = ret;
        }
    }

    PINT_sys_release(op_id);
    return error;
}

/****************************************************************/

static int symlink_init(PINT_client_sm *sm_p,
		       job_status_s *js_p)
{
    int ret = 1;
    job_id_t tmp_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink state: init\n");

    assert((js_p->error_code == 0) ||
           (js_p->error_code == SYMLINK_RETRY));

    if (js_p->error_code == SYMLINK_RETRY)
    {
        js_p->error_code = 0;

        ret = job_req_sched_post_timer(
            sm_p->msgarray_params.retry_delay, sm_p, 0, js_p, &tmp_id,
            pint_client_sm_context);
    }

    PINT_SM_GETATTR_STATE_FILL(
        sm_p->getattr,
        sm_p->object_ref,
        PVFS_ATTR_COMMON_ALL,
        PVFS_TYPE_DIRECTORY);
        
    return ret;
}

static int symlink_create_comp_fn(void *v_p,
                                  struct PVFS_server_resp *resp_p,
                                  int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;
    
    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink_create_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_CREATE);

    if (resp_p->status != 0)
    {
	return resp_p->status;
    }

    /* otherwise, just store the newly symlink'd meta handle */
    sm_p->u.sym.symlink_handle = resp_p->u.create.handle;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "*** Got newly created symlink "
                 "handle %Lu\n", Lu(sm_p->u.sym.symlink_handle));
    return 0;
}

static int symlink_setattr_comp_fn(void *v_p,
                                  struct PVFS_server_resp *resp_p,
                                  int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink_setattr_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_SETATTR);
    return resp_p->status;
}

static int symlink_crdirent_comp_fn(void *v_p,
                                   struct PVFS_server_resp *resp_p,
                                   int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink_crdirent_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_CRDIRENT);
    return resp_p->status;
}

static int symlink_delete_handle_comp_fn(void *v_p,
                                         struct PVFS_server_resp *resp_p,
                                         int index)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink_delete_handle_comp_fn\n");

    assert(resp_p->op == PVFS_SERV_REMOVE);
    return resp_p->status;
}

static int symlink_dspace_create_setup_msgpair(PINT_client_sm *sm_p,
                                               job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PVFS_handle_extent_array meta_handle_extent_array;
    PINT_sm_msgpair_state *msg_p = NULL;
    struct server_configuration_s *server_config = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink state: "
                 "dspace_create_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," create: posting create req\n");

    PINT_init_msgpair(sm_p, msg_p);

    server_config = PINT_get_server_config_struct(
        sm_p->object_ref.fs_id);

    ret = PINT_cached_config_get_next_meta(
        server_config, sm_p->object_ref.fs_id,
        &msg_p->svr_addr, &meta_handle_extent_array);

    PINT_put_server_config_struct(server_config);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
        return 1;
    }

    PINT_SERVREQ_CREATE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        PVFS_TYPE_SYMLINK,
        meta_handle_extent_array);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = meta_handle_extent_array.extent_array[0].first;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = symlink_create_comp_fn;

    return 1;
}

static int symlink_dspace_create_failure(PINT_client_sm *sm_p,
                                         job_status_s *js_p)
{
    sm_p->u.sym.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "symlink state: dspace_create_failure\n");
    return 1;
}

static int symlink_crdirent_setup_msgpair(PINT_client_sm *sm_p,
                                          job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "symlink state: crdirent_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," symlink: posting crdirent req\n");

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_CRDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->u.sym.link_name,
        sm_p->u.sym.symlink_handle,
        sm_p->object_ref.handle,
        sm_p->object_ref.fs_id,
        sm_p->u.sym.sys_attr.atime,
        sm_p->u.sym.sys_attr.mtime,
        sm_p->u.sym.sys_attr.ctime);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->object_ref.handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = symlink_crdirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, sm_p->object_ref.handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int symlink_crdirent_failure(PINT_client_sm *sm_p,
				   job_status_s *js_p)
{
    sm_p->u.sym.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "symlink state: crdirent_failure\n");

    PVFS_perror_gossip("crdirent failure", js_p->error_code);
    return 1;
}

static int symlink_setattr_setup_msgpair(PINT_client_sm *sm_p,
                                        job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;
    PVFS_time orig_mtime = sm_p->u.sym.sys_attr.mtime;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "symlink state: setattr_setup_msgpair\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG," symlink: posting setattr req\n");

    PINT_init_msgpair(sm_p, msg_p);

    /* encode the mtime as a directory version */
    sm_p->u.sym.sys_attr.mtime =
        PVFS_util_mktime_version(sm_p->u.sym.sys_attr.mtime);

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "using mtime %Lu and version %Lu\n",
        Lu(orig_mtime), Lu(sm_p->u.sym.sys_attr.mtime));

    PINT_SERVREQ_SETATTR_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->u.sym.symlink_handle,
        PVFS_TYPE_SYMLINK,
        sm_p->u.sym.sys_attr,
        (PVFS_ATTR_COMMON_TYPE | PVFS_ATTR_SYMLNK_ALL));

    /* fill in symlink specific attributes */
    msg_p->req.u.setattr.attr.u.sym.target_path =
        sm_p->u.sym.link_target;

    /* NOTE: path len always includes null terminator */
    msg_p->req.u.setattr.attr.u.sym.target_path_len =
        strlen(sm_p->u.sym.link_target) + 1;

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->u.sym.symlink_handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = symlink_setattr_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int symlink_setattr_failure(PINT_client_sm *sm_p,
                                   job_status_s *js_p)
{
    sm_p->u.sym.stored_error_code = js_p->error_code;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "symlink state: setattr_failure\n");
    return 1;
}

static int symlink_delete_handle_setup_msgpair(PINT_client_sm *sm_p,
                                               job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink state: "
                 "delete_handle_setup_msgpair_array\n");

    js_p->error_code = 0;

    gossip_debug(GOSSIP_CLIENT_DEBUG, " Preparing to remove "
                 "metafile handle %Lu\n", Lu(msg_p->handle));

    PINT_init_msgpair(sm_p, msg_p);

    PINT_SERVREQ_REMOVE_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->object_ref.fs_id,
        sm_p->u.sym.symlink_handle);

    msg_p->fs_id = sm_p->object_ref.fs_id;
    msg_p->handle = sm_p->u.sym.symlink_handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = symlink_delete_handle_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, sm_p->u.sym.symlink_handle,
        sm_p->object_ref.fs_id);

    if (ret)
    {
        gossip_err("Failed to map meta server address\n");
        js_p->error_code = ret;
    }
    return 1;
}

static int symlink_cleanup(PINT_client_sm *sm_p,
                          job_status_s *js_p)
{
    PVFS_object_ref symlink_ref;

    gossip_debug(GOSSIP_CLIENT_DEBUG, "symlink state: cleanup\n");

    PVFS_util_release_sys_attr(&sm_p->u.sym.sys_attr);

    sm_p->error_code = (sm_p->u.sym.stored_error_code ?
                        sm_p->u.sym.stored_error_code :
                        js_p->error_code);

    if (sm_p->error_code == 0)
    {
        symlink_ref.handle = sm_p->u.sym.symlink_handle;
        symlink_ref.fs_id = sm_p->object_ref.fs_id;

        /* fill in outgoing response fields */
        sm_p->u.sym.sym_resp->ref = symlink_ref;

        /* insert newly created symlink into the ncache */
        PINT_ncache_insert(sm_p->u.sym.link_name,
                           0 /* PVFS2_LOOKUP_LINK_NO_FOLLOW */,
                           symlink_ref, sm_p->object_ref);
    }
    else if ((PVFS_ERROR_CLASS(-sm_p->error_code) == PVFS_ERROR_BMI) &&
             (sm_p->u.sym.retry_count < sm_p->msgarray_params.retry_limit))
    {
        PINT_acache_invalidate(sm_p->object_ref);

        sm_p->u.sym.stored_error_code = 0;
        sm_p->u.sym.retry_count++;

        gossip_debug(GOSSIP_CLIENT_DEBUG, "Retrying symlink operation "
                     "(attempt number %d)\n", sm_p->u.sym.retry_count);

        js_p->error_code = SYMLINK_RETRY;
        return 1;
    }

    if (sm_p->msgarray && (sm_p->msgarray != &(sm_p->msgpair)))
    {
        free(sm_p->msgarray);
        sm_p->msgarray = NULL;
    }

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
