/* WARNING: THIS FILE IS AUTOMATICALLY GENERATED FROM A .SM FILE.
 * Changes made here will most likely be overwritten.
 */

/* 
 * (C) 2003 Clemson University and The University of Chicago 
 *
 * See COPYING in top-level directory.
 */

/** \file
 *  \ingroup mgmtint
 *
 *  PVFS2 management interface routines for creating directory entries
 *  that point to specific existing objects.  These are used primarily
 *  for file system repair purposes.
 */

#include <string.h>
#include <assert.h>

#include "client-state-machine.h"
#include "pvfs2-debug.h"
#include "job.h"
#include "gossip.h"
#include "str-utils.h"
#include "pint-servreq.h"
#include "pint-cached-config.h"
#include "PINT-reqproto-encode.h"

extern job_context_id pint_client_sm_context;

static int mgmt_create_dirent_init(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_create_dirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p);
static int mgmt_create_dirent_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p);

static int mgmt_create_dirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int i);

static union PINT_state_array_values ST_init[];
static union PINT_state_array_values ST_create_dirent_setup_msgpair[];
static union PINT_state_array_values ST_create_dirent_xfer_msgpair[];
static union PINT_state_array_values ST_cleanup[];

struct PINT_state_machine_s pvfs2_client_mgmt_create_dirent_sm =
{
	ST_init,
	"pvfs2_client_mgmt_create_dirent_sm"
};
static union PINT_state_array_values ST_init[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_create_dirent_init,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_create_dirent_setup_msgpair
};

static union PINT_state_array_values ST_create_dirent_setup_msgpair[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_create_dirent_setup_msgpair,
(union PINT_state_array_values) 0,
(union PINT_state_array_values) ST_create_dirent_xfer_msgpair,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_create_dirent_xfer_msgpair[] = {
(union PINT_state_array_values) 6,
(union PINT_state_array_values) &pvfs2_msgpairarray_sm,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) ST_cleanup
};

static union PINT_state_array_values ST_cleanup[] = {
(union PINT_state_array_values) 0,
(union PINT_state_array_values) mgmt_create_dirent_cleanup,
(union PINT_state_array_values) -1,
(union PINT_state_array_values) 7
};

# 73 "src/client/sysint/mgmt-create-dirent.sm"


/** Initiate creation of a directory entry pointing to a specific object.
 */
PVFS_error PVFS_imgmt_create_dirent(
    PVFS_object_ref parent_ref,
    char *entry,
    PVFS_handle entry_handle,
    PVFS_credentials *credentials,
    PVFS_mgmt_op_id *op_id,
    void *user_ptr)
{
    PVFS_error ret = -PVFS_EINVAL;
    PINT_client_sm *sm_p = NULL;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_imgmt_create_dirent entered\n");

    if ((parent_ref.handle == PVFS_HANDLE_NULL) ||
        (parent_ref.fs_id == PVFS_FS_ID_NULL) ||
        (entry_handle == PVFS_HANDLE_NULL) || !entry)
    {
        gossip_err("invalid (NULL) required argument\n");
        return ret;
    }

    sm_p = (PINT_client_sm *)malloc(sizeof(*sm_p));
    if (sm_p == NULL)
    {
        return -PVFS_ENOMEM;
    }
    memset(sm_p, 0, sizeof(*sm_p));

    PINT_init_msgarray_params(&sm_p->msgarray_params, parent_ref.fs_id);
    PINT_init_sysint_credentials(sm_p->cred_p, credentials);
    sm_p->parent_ref = parent_ref;
    sm_p->u.mgmt_create_dirent.entry = entry;
    sm_p->u.mgmt_create_dirent.entry_handle = entry_handle;

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, "Trying to create dirent %s under %Lu,%d\n",
        sm_p->u.mgmt_create_dirent.entry, Lu(parent_ref.handle),
        parent_ref.fs_id);

    return PINT_client_state_machine_post(
        sm_p, PVFS_MGMT_CREATE_DIRENT, op_id, user_ptr);
}

/** Create a directory entry pointing to a specific object.
 */
PVFS_error PVFS_mgmt_create_dirent(
    PVFS_object_ref parent_ref,
    char *entry,
    PVFS_handle entry_handle,
    PVFS_credentials *credentials)
{
    PVFS_error ret = -PVFS_EINVAL, error = 0;
    PVFS_mgmt_op_id op_id;

    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "PVFS_mgmt_create_dirent entered\n");

    ret = PVFS_imgmt_create_dirent(
        parent_ref, entry, entry_handle, credentials, &op_id, NULL);
    if (ret)
    {
        PVFS_perror_gossip("PVFS_imgmt_create_dirent call", ret);
        error = ret;
    }
    else
    {
        ret = PINT_mgmt_wait(op_id, "create_dirent", &error);
        if (ret)
        {
            PVFS_perror_gossip("PVFS_mgmt_wait call", ret);
            error = ret;
        }
    }

    PINT_mgmt_release(op_id);
    return error;
}

/****************************************************************/

static int mgmt_create_dirent_init(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG, "mgmt_create_dirent_init called\n");

    assert(js_p->error_code == 0);
    return 1;
}

static int mgmt_create_dirent_setup_msgpair(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    int ret = -PVFS_EINVAL;
    PINT_sm_msgpair_state *msg_p = NULL;

    js_p->error_code = 0;

    PINT_init_msgpair(sm_p, msg_p);

    gossip_debug(
        GOSSIP_CLIENT_DEBUG, " creating dirent entry %s with "
        "handle %Lu under parent %Lu,%d\n",
        sm_p->u.mgmt_create_dirent.entry,
        Lu(sm_p->u.mgmt_create_dirent.entry_handle),
        Lu(sm_p->parent_ref.handle), sm_p->parent_ref.fs_id);

    PINT_SERVREQ_CRDIRENT_FILL(
        msg_p->req,
        *sm_p->cred_p,
        sm_p->u.mgmt_create_dirent.entry,
        sm_p->u.mgmt_create_dirent.entry_handle,
        sm_p->parent_ref.handle,
        sm_p->parent_ref.fs_id,
        0,
        PVFS_util_get_current_time(),
        PVFS_util_get_current_time());

    msg_p->fs_id = sm_p->parent_ref.fs_id;
    msg_p->handle = sm_p->u.mgmt_create_dirent.entry_handle;
    msg_p->retry_flag = PVFS_MSGPAIR_NO_RETRY;
    msg_p->comp_fn = mgmt_create_dirent_comp_fn;

    ret = PINT_cached_config_map_to_server(
        &msg_p->svr_addr, msg_p->handle, msg_p->fs_id);

    if (ret)
    {
        gossip_err("Failed to map server address\n");
	js_p->error_code = ret;
    }
    return 1;
}

static int mgmt_create_dirent_comp_fn(
    void *v_p, struct PVFS_server_resp *resp_p, int index)
{
    PINT_client_sm *sm_p = (PINT_client_sm *)v_p;

    assert(resp_p->op == PVFS_SERV_CRDIRENT);

    if (resp_p->status == 0)
    {
        gossip_debug(
            GOSSIP_CLIENT_DEBUG,
            "  mgmt_create_dirent_comp_fn: dirent %s under %Lu,%d "
            "created\n", sm_p->u.mgmt_create_dirent.entry,
            Lu(sm_p->parent_ref.handle), sm_p->parent_ref.fs_id);
    }
    return resp_p->status;
}

static int mgmt_create_dirent_cleanup(
    PINT_client_sm *sm_p, job_status_s *js_p)
{
    gossip_debug(GOSSIP_CLIENT_DEBUG,
                 "mgmt_create_dirent_cleanup called\n");

    sm_p->error_code = js_p->error_code;

    sm_p->op_complete = 1;
    return 0;
}

/*
 * Local variables:
 *  mode: c
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 *
 * vim: ft=c ts=8 sts=4 sw=4 expandtab
 */
