/*
 * Test a single ace right.
 * -q: quiet
 * -u uid (seteuid before running test)
 *
 * Exit code:
 * 0 - success
 * 1 - failure
 * >1 - something went wrong (file missing, etc)
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>

extern int test(char *);

int qflag;

main(ac, av)
int ac;
char *av[];
{
    int i;
    uid_t uid;
    char *fname, *username = NULL;
    struct passwd *p;

    while ((i = getopt(ac, av, "qu:")) != -1) {
	switch (i) {
	case 'q':
	    qflag = 1;
	    break;
	case 'u':
	    username = optarg;
	    break;
	}
    }
    ac -= optind;
    av += optind;

    if (ac != 1) {
	fprintf(stderr, "missing file name\n");
	exit(2);
    }
    fname = av[0];

    if (username != NULL) {
	p = getpwnam(username);
	if (p != NULL)
	    uid = p->pw_uid;
	else {
	    if (sscanf(username, "%d", &i) != 1) {
		fprintf(stderr, "missing file name\n");
		exit(2);
	    }
	    uid = i;
	}
	if (seteuid(uid) < 0) {
	    perror("seteuid");
	    exit(2);
	}
    }

    exit(test(fname));
}
