#include <sys/types.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>

extern int qflag;

int
test(char *fname)
{
    DIR *d;
    struct dirent *dir;
    int e;

    if ((d = opendir(fname)) == NULL) {
	e = errno;
	if (!qflag || e != EACCES)
	    perror("opendir");
	return e;
    }

    if ((dir = readdir(d)) == NULL) {
	e = errno;
	if (!qflag || e != EACCES)
	    perror("readdir");
	return e;
    }

    return 0;
}
