#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>

extern int qflag;

int
test(char *fname)
{
    int fd, e;
    char buf[2];

    if ((fd = open(fname, (O_CREAT|O_EXCL), 0)) < 0) {
	e = errno;
	if (!qflag || e != EACCES)
	    perror("open");
	if (e == EACCES) {
	    /* make sure file wasn't really created anyway */
	    if ((fd = open(fname, (O_CREAT|O_EXCL), 0)) < 0) {
		if (errno == EEXIST) {
		    fprintf(stderr, "create failed but file exists??\n");
		    return 0;
		}
	    }
	}
	return e;
    }

    return 0;
}
