/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include "../crypto/crypto.h"

void usage(char * progname) {

  printf("Usage: %s [-e algorithm] keyfile1 keyfile2 ...\n", progname);
  printf("Writes a random key to keyfiles; algorithm is an integer from\n");
  printf("the following list:\n");
  print_algorithms();
  exit(1);
}

int main(int argc, char * argv[]) {
  extern char *optarg;
  extern int optind;
  int algorithm, ch;

  algorithm = DEFAULT_ALGORITHM;
  while ((ch = getopt(argc, argv, "e:")) != -1) {
    switch (ch) {
    case 'e':
      algorithm = atoi(optarg);
      break;
    case '?':
    default:
      usage(argv[0]);
    }
  }
  if (argc == optind) {
    usage(argv[0]);
  }
  for (; optind<argc; optind++) {
    write_random_key(argv[optind],algorithm);
  }
  exit(0);
}

