/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include "segnames.h"

char * segment_prefix;

void set_segment_name_prefix(char * prefix) {
    segment_prefix = prefix;
    sprintf(temp_segment_name, "%s-fill", segment_prefix);
}

void make_new_segment_names() {
    time_t now = time(0);
    static time_t then;
    static int suffix = 0;
    
    if (now == then) {
        suffix++;
    } else {
        suffix = 0;
    }
    sprintf(current_segment_name, "%s:%ld.%d", segment_prefix, 
	    (long int)now, suffix);
    sprintf(current_Xfile_name, "%sX:%ld.%d", segment_prefix,
	    (long int)now, suffix);
    then = now;

    /* printf( "File: %s\n", fileName ); */
    /* printf( "XFile: %s\n", fileNameX ); */
}
