#!/bin/sh

#
# COPYRIGHT    2000
# THE REGENTS OF THE UNIVERSITY OF MICHIGAN
# ALL RIGHTS RESERVED
#
# Permission is granted to use, copy, create derivative works
# and redistribute this software and such derivative works
# for any purpose, so long as the name of The University of
# Michigan is not used in any advertising or publicity
# pertaining to the use of distribution of this software
# without specific, written prior authorization.  If the
# above copyright notice or any other identification of the
# University of Michigan is included in any copy of any
# portion of this software, then the disclaimer below must
# also be included.
#
# THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
# FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
# PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
# MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
# WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
# REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
# FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
# CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
# OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
# IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGES.
#

# wrapper for listen, to log its trace output and restart it if it crashes

MON=`dirname $0`/../util/logmonitor
LOG=/var/log/listen.log
RCF=/tmp/listenrc$$

while :
do
	date
#	CMD="nice -n -20 `dirname $0`/listen"
	CMD=`dirname $0`/listen
	echo + $CMD $* >>$LOG
	($CMD $* 2>&1; echo $? >$RCF) | $MON -o $LOG -s SIGUSR1 -p /var/run/listen.pid
	RC=`cat $RCF`
	/bin/rm -f $RCF
	echo + $CMD returns, rc=$RC >>$LOG
	case $RC in
		100)	echo + MFS overrun >>$LOG; exit 1;;
		101)	echo + UFS overrun >>$LOG; exit 1;;
		102)	echo + listener interrupted >>$LOG; exit 1;;
		*)	echo + unknown return from listen >>$LOG; exit 1;;
	esac
done
