#!/usr/bin/perl
use strict;
use Time::HiRes qw(time);
use Getopt::Long;

my $format = 1;
my $cryptalg = 3;
my $cache = 2;
my $workdir = "/mfs";
my $extra_dump_args='';
my $extra_make_data_args='';

#on snoopy, use
#mount_mfs -s98304 swap /mfs
#or, under linux,
#mount -t tmpfs /dev/shm /mfs

my $test;
my $paramstring;
GetOptions("test=i" => \$test,
	   "params=s" => \$paramstring,
	   "cryptalg=i" => \$cryptalg,
	   "format=i" => \$format,
	   "cache=i" => \$cache,
	   "dump=s" => \$extra_dump_args,
	   "make=s" => \$extra_make_data_args);

my $pkt_dump_args = "-b$cache -e$cryptalg -z$format -V vkey -T tkey"
    . " -o $workdir/c.out -s $workdir/s.out -t $workdir/t.out "
    . $extra_dump_args;

if ($test == 0) {
    test0();
} elsif ($test == 1) {
    fixed_segment_test(map(eval,split(',',$paramstring)));
} else {
    print("unknown test\n");
}

sub time_pkt_dump {
    my($num_packets,$packet_size,$num_trials) = @_;

    system("../../bpf/make_data -p $num_packets -l $packet_size"
	   . "$extra_make_data_args $workdir/test.in");
    my $start = time();
    my $j;
    for ($j=0; $j<$num_trials; $j++) {
	system("../pkt_dump $pkt_dump_args $workdir/test.in >/dev/null");
    }
    return((time() - $start) / $num_trials);
}

sub test0 {

    my ($j,$start,$tot_elapsed);
    my $numtrials = 100;
    $tot_elapsed=0;
    for ($j=0; $j<$numtrials; $j++) {
	$start = time();
	system("true");
	$tot_elapsed += time() - $start;
    }
    print("average time = ",$tot_elapsed/$numtrials,"\n");
}

sub fixed_segment_test {
    my($segment_size,$low,$high,$increment,$num_trials) = @_;

    print "segment size: $segment_size bytes\n";
    my($i,$j,$num_packets,$start);
    my @results = ();
    for ($i = $low; $i<=$high; $i += $increment) {
	$num_packets = int($segment_size/$i);
	for ($j=0; $j<$num_trials; $j++) {
	    push(@results, [$i,time_pkt_dump($num_packets,$i,1)]);
	}
    }
    foreach (@results) {
	print("(",$_->[0],",",$_->[1],")\n");
    }
}
