#!/usr/bin/perl -w
use strict;
use Getopt::Long;
use Pod::Usage;

my $paramstring;
my $noisy=0;
my $cryptalg=3;
my $format=0;

GetOptions("verbose" => \$noisy,
	   "cryptalg=i" => \$cryptalg,
	   "format=i" => \$format,
	   "help|?" => sub {pod2usage(1)})
    or pod2usage(1);

if (@ARGV) {
    pod2usage(1);
}

sub run {
    my $command = shift();
    if ($noisy) {print("$command\n");}
    system($command);
}

run("../pkt_dump -b2 -e$cryptalg -z0 -V vkey -T tkey -o c.out -s s.out"
    ." -t t.out -c clear.out test.in".($noisy ? "": " >/dev/null"));

my $output =
    `../../decrypt/get_conversation_info -s s.out -t t.out -T tkey`;

my @clist = split('\n',$output);
shift(@clist); #remove header

if ($format != 0) {
    # the above was just a way to get the list of conversations! Now we
    # run pkt_dump again with the chosen format....
    run("../pkt_dump -b2 -e$cryptalg -z$format -V vkey -T tkey -o c.out"
	." -s s.out -t t.out -c clear.out test.in"
	.($noisy ? "": " >/dev/null"));
}

my $conv;
foreach $conv (@clist) {
    $conv =~ m/^\((.*),(.*)\) *\((.*),(.*)\)/
	or die("output of get_conversation_list_info has unexpected format");
    if ($noisy) {print($1,$2,$3,$4,"\n");}
    my($src,$dst,$fake_src,$fake_dst) = ($1,$2,$3,$4);
    unlink("filtered.out");
    run("tcpdump -r clear.out -w filtered.out src $1 and dst $2");
    run("../../crypto/make_conv_key -e$cryptalg"
	   ." -s $src -d $dst -V vkey -o ckey");
    unlink("decrypted_packets.out");
    run("../../decrypt/decrypt_packets -o decrypted_packets.out"
	." -c c.out -s $src -d $dst -f $fake_src -g $fake_dst -C ckey");
    my $tmp = `cmp filtered.out decrypted_packets.out`;
    if ($?) {
	if (!$noisy) {print($src,$dst,$fake_src,$fake_dst,"\n");}
	print $tmp;
	exit(1);
    }
    if ($format == 2) {

	# source key test:
	unlink("decrypted_packets.out");
	run("tcpdump -r clear.out -w filtered.out src $src");
	run("../../crypto/make_endpoint_key -e$cryptalg"
	    ." -s $src -V vkey -o skey");
	unlink("decrypted_packets.out");
	run("../../decrypt/decrypt_packets -o decrypted_packets.out"
	    ." -c c.out -s $src -S skey");
	$tmp = `cmp filtered.out decrypted_packets.out`;
	if ($?) {
	    print("src = $src\n");
	    print($tmp);
	    exit(1);
	}

	# destination key test:
	unlink("decrypted_packets.out");
	run("tcpdump -r clear.out -w filtered.out dst $dst");
	run("../../crypto/make_endpoint_key -e$cryptalg"
	    ." -d $dst -V vkey -o dkey");
	unlink("decrypted_packets.out");
	run("../../decrypt/decrypt_packets -o decrypted_packets.out"
	    ." -c c.out -d $dst -D dkey");
	$tmp = `cmp filtered.out decrypted_packets.out`;
	if ($?) {
	    print("dst = $dst\n");
	    print($tmp);
	    exit(1);
	}
    }
}

__END__

=head1 NAME

run_decrypt_packet_tests.pl - test decrypt_packets

=head1 SYNOPSIS

run_decrypt_packet_tests.pl [options]

 Options:
   --verbose
   --cryptalg
   --format
   --help

=cut
