/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#ifndef _APV_LIST_H_
#define _APV_LIST_H_

struct list {
    struct list *	l_next;
    int			l_type;
    int			l_cnt;

    union {
      /* For substitution table: */
      struct		{
	in_addr_t	real_addr;
	in_addr_t	fake_addr;
      } subst;

      /* For list of conversations (and caching of conversation keys): */
      struct {
	in_addr_t	addr_a;
	in_addr_t	addr_b;
	struct crypto_session session;
      } conv;

    } contents;

};

#define	L_TYPE_NULL	0
#define L_TYPE_SUBST	1
#define L_TYPE_CONV	2

extern struct list * newList( struct list * l );

int sorted_IP_pair(in_addr_t addrA, in_addr_t addrB);

/* The following is used in decrypt when loading the substitution table.*/
extern void list_insert_substitution(struct list * l,
				     in_addr_t real_addr,
				     in_addr_t fake_addr);

/* The following is also only used in decrypt. */
int find_real_ip(struct list * l, in_addr_t * addr);

/* new_substitution searches l for the unsubstituted IP address addr; if
   the address is found, it returns a pointer to the corresponding
   list element; otherwise, it creates a new element with a new
   substituted IP address and returns a pointer to that. */
extern in_addr_t new_substitution(struct list * l, in_addr_t addr);

extern struct crypto_session *
new_conversation(struct list * l,
		 in_addr_t addrA, in_addr_t addrB,
		 struct ip * ip,
		 struct crypto_session * vol_key_session);

extern struct list * find_substitution(struct list * l,
				       in_addr_t addr );

extern void walkList(struct list * l,
		     void (*p)(struct list * l, void * rock),
		     void * rock);

extern void printList(struct list * l, void * rock);

void list_get_substitution_table(struct list * l, int max_list_length,
				 char ** buffer, int * length);

void list_get_conversation_list(struct list * l, int max_list_length,
			   char ** buffer, int * length);

#endif /* _APV_LIST_H_ */
