/*
 * COPYRIGHT    2002
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

struct hash;

struct hash *
hash_init_substitution_table();

struct hash *
hash_init_key_schedule_cache();

in_addr_t
hash_obscure_address(struct hash * subs_table,
		     in_addr_t real_address);

int
hash_reveal_address(struct hash * subs_table,
		    in_addr_t * fake_address);

void
hash_insert_substitution(struct hash * subs_table,
			 in_addr_t real_address, in_addr_t fake_address);

struct crypto_session * 
hash_get_key_schedule(struct hash * keycache_table,
		      in_addr_t fake_src,
		      in_addr_t fake_dst,
		      struct ip * ip,
		      struct crypto_session * vol_key_session);

void
hash_destroy(struct hash * this);

/* The following functions also destroy subs_table and keycache_table.*/
void
hash_get_substitution_table(struct hash * subs_table,
			    int max_table_size, char ** buffer,
			    int * length);
void
hash_get_conversation_list(struct hash * keycache_table,
			   int max_table_size, char ** buffer,
			   int * length);

void
hash_print_substitution_table(struct hash * subs_table);

void
hash_print_key_schedule_cache(struct hash * keycache_table);

int
hash_get_substitution_table_size(struct hash * subs_table);
