/*
 * COPYRIGHT    2002
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

void init_substitution_table(int type); /* type chooses hash, btree, etc. */
void init_key_schedule_cache(int type);

/* Maps given real address to fake one, looking it up or creating a new one as
   necessary. */
in_addr_t obscure_address(in_addr_t real_address);

/* Maps given fake address to real one, returning 0 if it doesn't know the
   mapping for this address, 1 otherwise. */
int reveal_address(in_addr_t * fake_address);

/* Used by decrypt when creating substitution table from file: */
void insert_substitution(in_addr_t real_address, in_addr_t fake_address);

/* Looks up, or (as necessary) calculates key schedule from untranslated ip
   addresses on the packet.  Also stores translated ip addresses, which may
   later be written out to t: file.*/
struct crypto_session * 
get_key_schedule(in_addr_t fake_src,
		 in_addr_t fake_dst,
		 struct ip * ip,
		 struct crypto_session * vol_key_session);

/* Return buffer with substitution table (or list of conversations),
   ready to be encrypted and written to disk. Also destroy the
   table. max_table_size is an upper bound on the number of items in the
   returned table.  Eventually I'll get rid of that argument.*/
void get_substitution_table(int max_table_size, char ** buffer,
			    int * length);
void get_conversation_list(int max_table_size, char ** buffer,
			   int * length);

/* For debugging purposes: */
void print_substitution_table();
void print_key_schedule_cache();
int get_substitution_table_size();

