/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/time.h>
#ifdef LOCAL_BPF_HEADERS
/* So we can build this on a system w/o kernel changes */
#include "../sys/net/bpf.h"
#else
#include "/usr/src/sys/net/bpf.h"
#endif
#include <pcap.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <err.h>
#include <assert.h>
#include <string.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#ifdef __FreeBSD__
typedef u_int32_t in_addr_t;
#endif

#include "histogram.h"

/* The fixed-length part of the IP header is all we care about: */
#define IP_HDR_SIZE 20

void usage(char * prog) {
  printf("usage: %s file1 file2 ...\n",prog);
  printf("generates histogram of packet sizes in the given files.\n");
  printf("Assumes the files are in pcap format.");
  printf("Note that packet sizes include 14-byte ethernet header.");
  exit(1);
}

void process_packet(u_char * user, struct pcap_pkthdr * hdr, u_char * pkt) {

  if (add_one_to_histogram(hdr->len) == -1)
    fprintf(stderr,"Woah! %s has a bad packet length\n",user);
}

void process_file(char * filename) {
  pcap_t * infile;
  char * error_msg;
  int retval;

  if ((infile=pcap_open_offline(filename,error_msg)) == NULL)
    errx(1,error_msg);
  retval = pcap_dispatch(infile,0,(pcap_handler)process_packet,filename);
  if (retval == -1)
    errx(1,pcap_geterr(infile));
  if (retval != 0)
    errx(1,"I was expecting pcap_dispatch to return 0, but it returned %d\n",
	 retval);
  pcap_close(infile);
}

int main(int argc, char * argv[])
{
  int i;

  init_histogram();
  for (i=1; i<argc; i++) {
    process_file(argv[i]);
  }
  dump_histogram();

  exit(0);
}
