/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#ifdef LOCAL_BPF_HEADERS
/* So we can build this on a system w/o kernel changes */
#include "../sys/net/bpf.h"
#else
#include "/usr/src/sys/net/bpf.h"
#endif
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <err.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#ifdef __FreeBSD__
typedef u_int32_t in_addr_t;
#endif

#include "../bpf/parse_bpf.h"
#include "../crypto/crypto.h"
#include "../crypto/crypto_file.h"
#include "histogram.h"

void usage(char * prog) {
  printf("usage: %s file1 file2 ...\n",prog);
  printf("generates histogram of packet sizes in the given files.\n");
  printf("Note that packet sizes include 14-byte ethernet header.");
  exit(1);
}

void count_one_packet(struct crypto_file * infile,
		      struct crypto_packet * packet,
		      void * user) {
  add_one_to_histogram(get_pkt_size(packet));
}

int main(int argc, char * argv[])
{
  struct crypto_file * infile;
  int i;

  init_histogram();
  for (i=1; i<argc; i++) {
    infile = open_input_crypto_file(argv[i]);
    read_crypto_file(infile,NULL,&count_one_packet,NULL);
    close_input_crypto_file(infile);
  }
  dump_histogram();

  exit(0);
}
