/*
 * COPYRIGHT    2002
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef LOCAL_BPF_HEADERS
/* So we can build this on a system w/o kernel changes */
#include "../sys/net/bpf.h"
#else
#include "/usr/src/sys/net/bpf.h"
#endif

#include "../bpf/parse_bpf.h"
#include "../crypto/crypto.h"
#include "../dump/cache.h"
#include "../crypto/crypto_file.h"


void usage(char * prog) {
  fprintf(stderr,
"usage: %s -s subs_table_file -t conversation_list\n"
"	  -T tt_key -e encryption_algorithm\n"
"prints out a list of conversations, with both real and corresponding\n"
"translated addresses.\n"
	  ,prog);
  exit(1);
}

int main(int argc, char * argv[]) {
  extern char * optarg;
  extern int optind;
  int optch;
  char * sfilename = NULL;
  char * tfilename = NULL;
  char * tkey_filename = NULL;
  struct crypto_key_ring * keys;
  int cryptalg = DEFAULT_ALGORITHM;

  while ((optch = getopt(argc,argv,"e:s:t:T:")) != -1) {
    switch(optch) {
    case 's':
      sfilename = optarg;
      break;
    case 't':
      tfilename = optarg;
      break;
    case 'T':
      tkey_filename = optarg;
      break;
    case 'e':
      cryptalg = atoi(optarg);
      break;
    default:
      usage(argv[0]);
    }
  }
  if (optind != argc)
    usage(argv[0]);
  keys = init_crypto_keys(cryptalg);
  get_tr_key(keys,tkey_filename);
  init_subs_table(keys,sfilename);
  {
      in_addr_t * conv_list;
      int conv_list_length;
      char      src[INET_ADDRSTRLEN],     dst[INET_ADDRSTRLEN];
      char fake_src[INET_ADDRSTRLEN],fake_dst[INET_ADDRSTRLEN];
      int i;

      load_cbc_encrypted_buffer(keys->tr_key,tfilename,
				(char **)&conv_list,&conv_list_length);
      printf("(%15s,%15s) (%15s,%15s)\n","source","dest",
	     "fake source","fake dest");
      for (i=0; i<conv_list_length/sizeof(in_addr_t); i+= 2) {
	inet_ntop(AF_INET,&conv_list[i],  fake_src,INET_ADDRSTRLEN);
	inet_ntop(AF_INET,&conv_list[i+1],fake_dst,INET_ADDRSTRLEN);
	if (!reveal_address(&conv_list[i]))
	  strcpy(src,"?");
	else
	  inet_ntop(AF_INET,&conv_list[i],  src,INET_ADDRSTRLEN);	  
	if (!reveal_address(&conv_list[i+1]))
	  strcpy(dst,"?");
	else
	  inet_ntop(AF_INET,&conv_list[i+1],dst,INET_ADDRSTRLEN);
	printf("(%15s,%15s) (%15s,%15s)\n",
	       src,dst,fake_src,fake_dst);
      }
  }
  exit(0);
}








