/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <err.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#ifdef LOCAL_BPF_HEADERS
/* So we can build this on a system w/o kernel changes */
#include "../sys/net/bpf.h"
#else
#include "/usr/src/sys/net/bpf.h"
#endif

#include "../bpf/parse_bpf.h"
#include "../crypto/crypto.h"

void usage(char * prog) {
  fprintf(stderr,
"usage: %s [-e cipher] -k key [-d] -i infile -o outfile\n"
"decrypts with -d, encrypts otherwise\n"
"choice of ciphers:\n"
	  ,prog);
  print_algorithms();
  exit(1);
}

int main(int argc, char * argv[]) {
  extern char * optarg;
  extern int optind;
  int optch;
  char * in_filename = NULL;
  char * out_filename = NULL;
  char * key_filename = NULL;
  char key[MAX_KEY_LENGTH];
  int decrypt = 0;
  int cryptalg = DEFAULT_ALGORITHM;

  while ((optch = getopt(argc,argv,"de:i:k:o:")) != -1) {
    switch (optch) {
    case 'd':
      decrypt=1;
      break;
    case 'e':
      cryptalg = atoi(optarg);
      break;
    case 'i':
      in_filename = optarg;
      break;
    case 'k':
      key_filename = optarg;
      break;
    case 'o':
      out_filename = optarg;
      break;
    default:
      usage(argv[0]);
    }
  }
  read_key_file(key_filename,key,cryptalg);
  {
    char * buffer;
    int length;
    struct crypto_session session;
    get_crypto_session(&session,cryptalg,CBC_MODE,(decrypt? DECRYPT : ENCRYPT),
		       key,0);
    if (decrypt) {
      FILE * outfile = NULL;

      load_cbc_encrypted_buffer(&session,in_filename,&buffer,&length);
      if ((outfile = fopen(out_filename,"w")) == NULL)
	errx(1,"unable to open %s",out_filename);
      if (fwrite(buffer,1,length,outfile) != length)
	errx(1,"error writing to %s",out_filename);
    } else {
      FILE * infile = NULL;
      int read;
      
#define READ_INC 1024
      if ((infile = fopen(in_filename,"r")) == NULL)
	errx(1,"unable to open %s",in_filename);
      length = 0;
      if ((buffer = malloc(READ_INC)) == NULL)
	  errx(1,"unable to malloc space for read buffer");
      while ((read = fread(buffer+length,1,READ_INC,infile)) 
	     == READ_INC) {
	length += read;
	if ((buffer = realloc(buffer,length+READ_INC)) == NULL)
	    errx(1,"unable to realloc space for read buffer");
      }
      if (!feof(infile)) {
	errx(1,"error reading from %s",in_filename);
      } else {
	length += read;
	save_cbc_encrypted_buffer(&session,out_filename,buffer,length);
      }
    }
  }
  exit(0);
}











