/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */
#include <sys/types.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <err.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "../crypto/crypto.h"

#ifdef __FreeBSD__
typedef u_int32_t in_addr_t;
#endif

void usage(char * progname) {

  printf("Usage: %s [-e algorithm] -s segment_file_name\n",progname);
  printf("       -o segment_key_file -V volume key -e cipher\n");
  printf("generates a key which will decrypt a segment encrypted in\n");
  printf("segment mode, given the name of the segment file.\n");
  printf("The cipher must be chosen from the following list:\n");
  print_algorithms();
  exit(1);
}

int main(int argc, char * argv[]) {
  extern char *optarg;
  extern int optind;
  int ch;
  int cryptalg = DEFAULT_ALGORITHM;
  int keylen;
  char volume_key[MAX_KEY_LENGTH], * seg_key;
  char * seg_filename = NULL;
  struct crypto_session vol_key_session;
  FILE * outfile = NULL;

  while ((ch = getopt(argc, argv, "e:s:o:V")) != -1) {
    switch (ch) {
    case 'e':
      cryptalg = atoi(optarg);
      break;
    case 's':
      seg_filename = optarg;
      break;
    case 'o':
      if ((outfile = fopen(optarg,"w")) == NULL)
	errx(1,"Error opening %s",optarg);
      break;
    case 'V':
      read_key_file(optarg,volume_key,cryptalg);
      get_crypto_session(&vol_key_session,cryptalg,CBC_MODE,ENCRYPT,
			 volume_key,0);
      break;
    case '?':
    default:
      usage(argv[0]);
    }
  }
  if (optind<5)
    usage(argv[0]);

  seg_key = make_segment_key(&vol_key_session,seg_filename,cryptalg);
  keylen = algorithms[cryptalg].key_length;
  if (fwrite(seg_key,1,keylen,outfile) != keylen)
    errx(1,"error writing key");
  fclose(outfile);
  exit(0);
}
