/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */


#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "crypto.h"

void usage(char * progname) {
  fprintf(stderr,
"usage: %s [-s buffer size] [-n number of buffers] [-e cipher]\n",
	  progname);
  fprintf(stderr,
"available ciphers:\n");
  print_algorithms();
  exit(1);
}

int main(int argc, char ** argv) {
  char * test_data;
  char * key = "1234567812345678";
  char iv[16];
  struct crypto_session session;
  extern char *optarg;
  extern int optind;
  int optch;
  int numtrials = 1000000;
  int buffersize = 1;
  int i;
  struct timeval start, stop;
  long elapsed;
  double mbps;
  int cryptalg = DEFAULT_ALGORITHM;
  
  while ((optch = getopt(argc, argv, "e:n:s:")) != -1) {
    switch (optch) {
    case 'e':
      cryptalg = atoi(optarg);
      break;
    case 'n':
      numtrials = atoi(optarg);
      break;
    case 's':
      buffersize = atoi(optarg);
      break;
    case '?':
    default:
      usage(argv[0]);
    }
  }

  get_crypto_session(&session,cryptalg,CBC_MODE,ENCRYPT,key,0);
  buffersize = get_encrypted_length(session.algorithm,buffersize);
  test_data = (char *)malloc(buffersize);
  /* data_save = (char *)malloc(buffersize); */
  /* memcpy(data_save,test_data,buffersize); */
  /* memcpy(iv_save,iv,sizeof(iv)); */
  printf("encrypting %d buffers of size %d bytes\n",numtrials,buffersize);
  gettimeofday(&start,NULL);
  for (i=0; i<numtrials; i++) {
    crypt_buffer(&session,test_data,buffersize,iv);
  }
  gettimeofday(&stop,NULL);
  elapsed = 1000*(stop.tv_sec - start.tv_sec)
    + (stop.tv_usec - start.tv_usec)/1000.;
  printf("execution time = %ld ms ",elapsed);
  mbps = (numtrials*buffersize*8/(1024*1024)) / (elapsed/1000.0);
  printf("(%.1f mbps)\n",mbps);

  /* add decryption and comparison here */

  exit(0);
}


