/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#ifndef _APV_PARSE_BPF_H_
#define _APV_PARSE_BPF_H_
/* The maximum ethernet packet is 1500; we allow a little extra for
   padding and the bpf header (and other stuff). This is sloppy. */
#define MAX_PACKET_SIZE 1700

#define BPF_HDR_SIZE 18
/* Note that sizeof(struct bpf_hdr) does *not* do the right thing,
   because gcc pads the bpf_hdr structure with two extra bytes (making
   it 20 bytes instead of 18). */

/* read_bpf reads the next bpf header into hdr, and the captured
   data into bpf_content, and leaves the file pointer at the beginning of
   the next packet.  A nonzero return value indicates an error or an
   end of file.  The buffer bpf_hdr points to must have size at least
   MAX_PACKET_SIZE.  If padding is nonzero, then read_bpf expects each
   packet to have alignment padding appended. */
int read_bpf(FILE * infile, struct bpf_hdr * hdr,
	     char * bpf_content, int padding);

/* write_bpf writes bpf_hdr and packet to outfile. A nonzero return
   value indicates an error.  If padding is nonzero, then write_bpf
   adds alignment padding after each bpf packet. */
int write_bpf(FILE * outfile, struct bpf_hdr * hdr,
	      char * packet, int padding);

/* pprint_bpf just pretty-prints the packet to outfile, for debugging.
   (Note: it's not actually "pretty", and gives virturally no useful
   information. May want to copy code from display.c.) */
void pprint_bpf(FILE * outfile, struct bpf_hdr * hdr, char * packet);

/* pcap stuff */

/* Writes our standard pcap file header; returns number of bytes
   written, or zero on failure.  If snaplen is zero, then the default
   snaplen (ETHERMTU+ETHER_HDR_LEN = 1514) is used.*/
int write_pcap_header(FILE * outfile, int snaplen);


#endif /* _APV_PARSE_BPF_H_ */






