/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/time.h>
#include <stdio.h>
#ifndef __linux__
#ifdef LOCAL_BPF_HEADERS
#include "../sys/net/bpf.h"
#else
#include <net/bpf.h>
#endif
#endif
#include "parse_bpf.h"

int main() {
  FILE * infile, * outfile;
  struct bpf_hdr * this_hdr;
  char * bpf_content;
  char buffer[MAX_PACKET_SIZE];

  infile = fopen("../dump/tests/test.in","r");
  if (infile == NULL) {
    perror("failed to open ../dump/tests/test.in");
    exit(1);
  }
  outfile = fopen("test.out","w");
  if (outfile == NULL) {
    perror("failed to open test.out");
    exit(1);
  }
  this_hdr = (struct bpf_hdr *)buffer;
  bpf_content = buffer + BPF_HDR_SIZE;
  while (!read_bpf(infile,this_hdr,bpf_content,1)) {
    pprint_bpf(stdout,this_hdr,bpf_content);
    if (write_bpf(outfile,this_hdr,bpf_content,0)) {
      perror("error writing bpf packet");
      exit(1);
    }
  }
  if (!feof(infile)) {
    perror("read_bpf error");
    exit(1);
  }
  fclose(infile);
  fclose(outfile);
  exit(0);
}

