#!/bin/sh

#
# COPYRIGHT    2001
# THE REGENTS OF THE UNIVERSITY OF MICHIGAN
# ALL RIGHTS RESERVED
#
# Permission is granted to use, copy, create derivative works
# and redistribute this software and such derivative works
# for any purpose, so long as the name of The University of
# Michigan is not used in any advertising or publicity
# pertaining to the use of distribution of this software
# without specific, written prior authorization.  If the
# above copyright notice or any other identification of the
# University of Michigan is included in any copy of any
# portion of this software, then the disclaimer below must
# also be included.
#
# THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
# FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
# PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
# MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
# WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
# REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
# FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
# CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
# OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
# IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGES.
#

# wrapper for pilot.tcl, to log its trace output and restart it if it crashes

LOG=/var/log/pilot.log
MON=`dirname $0`/../util/logmonitor
SYNC=`dirname $0`/../util/apvsync
VOLNUM=./volInfo/volNum

trap '
	CMD="$SYNC produce `cat $VOLNUM`"; \
	echo "$0 interrupted, forcing archive of current volume" >>$LOG; \
	echo + $CMD >>$LOG; \
	$CMD >>$LOG 2>>$LOG; \
	exit 1' 2

while :
do
	date
	CMD="`dirname $0`/pilot.tcl --format=conversation --ufsmount=/scratch0"
	echo + $CMD $*
	$CMD $*
	echo + $CMD returns, rc=$?
        sleep 20
done 2>&1 | $MON -o $LOG -p /var/run/pilot.pid
