#!/usr/bin/perl

#
# COPYRIGHT    2000
# THE REGENTS OF THE UNIVERSITY OF MICHIGAN
# ALL RIGHTS RESERVED
# 
# Permission is granted to use, copy, create derivative works
# and redistribute this software and such derivative works
# for any purpose, so long as the name of The University of
# Michigan is not used in any advertising or publicity
# pertaining to the use of distribution of this software
# without specific, written prior authorization.  If the
# above copyright notice or any other identification of the
# University of Michigan is included in any copy of any
# portion of this software, then the disclaimer below must
# also be included.
# 
# THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
# FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
# PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O 
# MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
# WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
# REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
# FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
# CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
# OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
# IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGES.
#

require Exporter;
use vars qw(@ISA $VERSION);
$VERSION = 0.1;


##########################################################################
# ChangerElement is the BASE class
##########################################################################
package ChangerElement;
@ISA = qw(Exporter);

sub new {
	print "Creating new ChangerElement...\n" if ($debug);
	my $type = shift;	
	print "new ChangerElement has '@_'\n" if ($debug); 
	my $self = {@_};
	return bless $self, $type;
}

#------------------------------------------------------------------------#
# attribute access methods
#------------------------------------------------------------------------#
sub contents() {
	my $self = shift;
	if (@_) { $self->{contents} = shift; }
	return $self->{contents};
}

sub type() {
	my $self = shift;
	if (@_) { $self->{type} = shift; }
	return $self->{type};
}

sub status() {
	my $self = shift;
	if (@_) { $self->{status} = shift; }
	return $self->{status};
}

sub errors() {
	my $self = shift;
	if (@_) { $self->{errors} = shift; }
	return $self->{errors};
}

sub full() {
	my ($self, @args) = @_;
	return 1 if ($self->{status} =~ m/full/i);
	return 0;
}

##########################################################################
# Portal is derived from ChangerElement
##########################################################################
package Portal;
@ISA = qw(ChangerElement Exporter);

sub new {
	print "Creating new Portal ...\n" if ($debug);
	my $type = shift;	
	my $self = ChangerElement->new(@_);
	return bless $self, $type;
}

##########################################################################
# Slot is derived from ChangerElement
##########################################################################
package Slot;
@ISA = qw(ChangerElement Exporter);

sub new {
	print "Creating new Slot ...\n" if ($debug);
	my $type = shift;	
	my $self = ChangerElement->new(@_);
	return bless $self, $type;
}

##########################################################################
# Drive is derived from ChangerElement
##########################################################################
package Drive;
@ISA = qw(ChangerElement Exporter);

sub new {
	print "Creating new Drive ...\n" if ($debug);
	my $type = shift;	
	my $self = ChangerElement->new(@_);
	$self->{came_from} = "";
	return bless $self, $type;
}

sub came_from() {
	my $self = shift;
	if (@_) { $self->{came_from} = shift; }
	return $self->{came_from};
}

##########################################################################
# Picker is derived from ChangerElement
##########################################################################
package Picker;
@ISA = qw(ChangerElement Exporter);

sub new {
	print "Creating new Picker ...\n" if ($debug);
	my $type = shift;	
	my $self = ChangerElement->new(@_);
	return bless $self, $type;
}

sub contents() {
	return "N/A";
}

##########################################################################
# The main stuff!
##########################################################################

return 1;
