/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>

#include	<netinet/in_systm.h>
#include	<netinet/in.h>
#include	<net/if.h>
#include	<net/if_llc.h>
/* So we can build on a system w/o the kernel changes */
#include	"../sys/net/bpf.h"	/* <net/bpf.h> */
#include	<netinet/if_ether.h>

#include	<netinet/ip.h>
#include	<netinet/udp.h>
#include	<netinet/tcp.h>
#include	<netinet/ip_icmp.h>

#include	<ctype.h>

#include	"print.h"
#include	"../crypto/crypto.h"
#include        "sample.h"


/*
** ==================================================
**
**
*/
struct ether_header enet_hdr[1];

#define N	64*1024
int	cnt[N];
int	len[N];

int	cnt802[N];
int	len802[N];

int	ipx;
int	ipxLen;

int	iso;
int	isoLen;

void sample( struct packet * pp, int pl)
{
    struct ether_header * eth;
    unsigned int ndx;

    eth = (struct ether_header *)pp;

    if (ntohs(eth->ether_type) <= ETHERMTU) {
	/* 802.3 */
	struct llc * llc = (struct llc *)&(((char *)eth)[14]);
	if (llc->llc_dsap == 0xff && llc->llc_ssap == 0xff) {
	    ipx++;
	    ipxLen += pl;
	} else if (llc->llc_dsap == 0xaa && llc->llc_ssap == 0xaa) {
	    ndx = (unsigned)(ntohs(llc->llc_un.type_snap.ether_type));
	    cnt802[ndx]++;
	    len802[ndx] += pl;
	} else if (llc->llc_dsap == 0xe0 && llc->llc_ssap == 0xe0) {
	    iso++;
	    isoLen += pl;
	} else {
	    PRINT(( "<%x,%x,%d,%d>\n", llc->llc_dsap, llc->llc_ssap,
		llc->llc_control, ntohs(eth->ether_type) ));
	} 

    } else {
	ndx = (unsigned)(ntohs(eth->ether_type));
	cnt[ndx]++;
	len[ndx] += pl;
    }
}

void sample_dmp( ) 
{
    extern int totLen, totPackets;
    int i;


    if (ipx) {
	printf( "ipx	ipx	%d	%d\n", ipx, ipxLen );
	printf( "		%f	%f\n", ipx*100./totPackets, ipxLen*100./totLen );
    }
    if (iso) {
	printf( "iso	iso	%d	%d\n", iso, isoLen );
	printf( "		%f	%f\n", iso*100./totPackets, isoLen*100./totLen );
    }
    for (i=0; i<N; ++i) {
	if (cnt[i]) {
	    printf( "dix	%x	%d	%d\n", i, cnt[i], len[i] );
	    printf( "		%f	%f\n", cnt[i]*100./totPackets,len[i]*100./totLen );
	}
   } 

    for (i=0; i<N; ++i) {
	if (cnt802[i]) {
	    printf( "802	%x	%d	%d\n", i, cnt802[i], len802[i] );
	    printf( "		%f	%f\n", cnt802[i]*100./totPackets,
							len802[i]*100./totLen );
	}
    }
}








