/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <sys/types.h>
#include "find_ip.h"

struct ip * find_ip_start(char * ether_start) {
  u_int16_t ether_type;

  ether_type = ntohs((u_int16_t *)(ether_start + 12));
  if (ether_type <= ETHER_MTU) {
    /* This is an 802.2 packet; see RFC 1042. We need to check the LLC
       and SNAP headers to see whether it contains an IP packet. */
    ether_type = ntohs((u_int16_t *)(ether_start + 20));
    if (memcmp(ether_start+14,"\xaa\xaa\x03\x00\x00\x00",6) &&
	(ether_type == ETHERTYPE_IP)) {
      return((struct ip *)(ether_start + 22));
    }
    else {
      return(NULL);
    }
  } else if (ether_type == ETHERTYPE_IP) {
    /* This is an ethernet version 2 packet containing an IP packet. */
    return ((struct ip *)(ether_start + 14));
  } else {
    return(NULL);
  }
}
