/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#ifndef _APV_BTREE_H_
#define _APV_BTREE_H_

#include "db.h"

extern DB *newDB(const char *db_name);
extern in_addr_t newDB_substitution(DB *dbp, in_addr_t real_addr);
extern void insertDB_substitution(DB *dbp,
				  in_addr_t real_addr,
				  in_addr_t fake_addr);
extern int findDB_real_ip(DB *dbp, in_addr_t * real_addr);
extern int getDB_substitution_table(DB *dbp, int max_list_length,
	char ** buffer, int * length);
extern struct crypto_session *
newDB_conversation(DB *dbp,
		   in_addr_t subs_addrA, in_addr_t subs_addrB,
		   struct ip * ip,
		   struct crypto_session * vol_key_session);
extern int getDB_conversation_list(DB *dbp, int max_list_length,
				   char ** buffer, int * length);
extern void closeDB(DB *dbp);

#endif /* _APV_BTREE_H_ */
