/*
 * COPYRIGHT    2001
 * THE REGENTS OF THE UNIVERSITY OF MICHIGAN
 * ALL RIGHTS RESERVED
 *
 * Permission is granted to use, copy, create derivative works
 * and redistribute this software and such derivative works
 * for any purpose, so long as the name of The University of
 * Michigan is not used in any advertising or publicity
 * pertaining to the use of distribution of this software
 * without specific, written prior authorization.  If the
 * above copyright notice or any other identification of the
 * University of Michigan is included in any copy of any
 * portion of this software, then the disclaimer below must
 * also be included.
 *
 * THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION
 * FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS FOR ANY
 * PURPOSE, AND WITHOUT WARRANTY BY THE UNIVERSITY O
 * MICHIGAN OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
 * WITHOUT LIMITATION THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
 * REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE
 * FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OF THE SOFTWARE, EVEN
 * IF IT HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGES.
 */

#include <stdio.h>
#include "crypto.h"

int main() {
  char test_data[17] = "0000000000000000\0";
  char * key = "1234567812345678";
  char iv[17] = "0000000000000000\0";
  char * iv_save;
  struct crypto_session session;

  printf("initial buffer: %s\n",test_data);
  get_crypto_session(&session,NONE,ECB_MODE,ENCRYPT,NULL,0);
  crypt_buffer(&session,test_data,16,NULL);
  printf("after NONE encryption: %s\n",test_data);

  /* iv fine here */
  get_crypto_session(&session,AES,CBC_MODE,ENCRYPT,key,0);
  /* iv overwitten here */
  iv_save = (char *)malloc(16);
  memcpy(iv_save,iv,16);
  crypt_buffer(&session,test_data,16,iv);
  printf("after AES, CBC: %s\n",test_data);
  get_crypto_session(&session,AES,CBC_MODE,DECRYPT,key,0);
  crypt_buffer(&session,test_data,16,iv_save);
  printf("after AES, CBC, decryption: %s\n",test_data);

  exit(0);
}
